/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DeleteCompletedHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent executionEvent) {
        MarkerSupportView markerSupportView = this.getView(executionEvent);
        if (markerSupportView == null) {
            return this;
        }
        List list = this.getCompletedTasks(markerSupportView);
        if (list.size() == 0) {
            MessageDialog.openInformation((Shell)markerSupportView.getSite().getShell(), (String)MarkerMessages.deleteCompletedTasks_dialogTitle, (String)MarkerMessages.deleteCompletedTasks_noneCompleted);
            return this;
        }
        String string = list.size() == 1 ? MarkerMessages.deleteCompletedTasks_permanentSingular : NLS.bind((String)MarkerMessages.deleteCompletedTasks_permanentPlural, (Object)String.valueOf(list.size()));
        if (!MessageDialog.openConfirm((Shell)markerSupportView.getSite().getShell(), (String)MarkerMessages.deleteCompletedTasks_dialogTitle, (String)string)) {
            return markerSupportView;
        }
        IMarker[] iMarkerArray = new IMarker[list.size()];
        list.toArray(iMarkerArray);
        DeleteMarkersOperation deleteMarkersOperation = new DeleteMarkersOperation(iMarkerArray, MarkerMessages.deleteCompletedAction_title);
        this.execute((IUndoableOperation)deleteMarkersOperation, MarkerMessages.deleteCompletedTasks_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(markerSupportView.getSite().getShell()));
        return this;
    }

    private List getCompletedTasks(ExtendedMarkersView extendedMarkersView) {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        MarkerSupportItem[] markerSupportItemArray = extendedMarkersView.getAllConcreteItems();
        int n = 0;
        while (n < markerSupportItemArray.length) {
            MarkerSupportItem markerSupportItem = markerSupportItemArray[n];
            if (markerSupportItem.getAttributeValue("done", false) && markerSupportItem.getMarker() != null) {
                arrayList.add(markerSupportItem.getMarker());
            }
            ++n;
        }
        return arrayList;
    }
}

