/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DeleteHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        MarkerSupportView markerSupportView = this.getView(executionEvent);
        if (markerSupportView == null) {
            return this;
        }
        final IMarker[] iMarkerArray = this.getSelectedMarkers(executionEvent);
        MessageDialog messageDialog = new MessageDialog(markerSupportView.getSite().getShell(), MarkerMessages.deleteActionConfirmTitle, null, MarkerMessages.deleteActionConfirmMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (messageDialog.open() != 0) {
            return markerSupportView;
        }
        WorkspaceJob workspaceJob = new WorkspaceJob(IDEWorkbenchMessages.MarkerDeleteHandler_JobTitle){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(IDEWorkbenchMessages.MarkerDeleteHandler_JobMessageLabel, 10 * iMarkerArray.length);
                try {
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        if (iProgressMonitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            iMarkerArray[n].delete();
                            iProgressMonitor.worked(10);
                            ++n;
                        }
                        catch (CoreException coreException) {
                            Policy.handle(coreException);
                            throw coreException;
                        }
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setUser(true);
        workspaceJob.schedule();
        return this;
    }
}

