/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.views.markers.DescriptionFieldFilter;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerSupportConstants;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DescriptionConfigurationArea
extends FilterConfigurationArea {
    private Combo descriptionCombo;
    private Text descriptionText;

    public void apply(MarkerFieldFilter markerFieldFilter) {
        DescriptionFieldFilter descriptionFieldFilter = (DescriptionFieldFilter)markerFieldFilter;
        if (this.descriptionCombo.getSelectionIndex() == 0) {
            descriptionFieldFilter.setContainsModifier("CONTAINS");
        } else {
            descriptionFieldFilter.setContainsModifier(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY);
        }
        descriptionFieldFilter.setContainsText(this.descriptionText.getText());
    }

    public void createContents(Composite composite) {
        this.createDescriptionGroup(composite);
    }

    public void initialize(MarkerFieldFilter markerFieldFilter) {
        DescriptionFieldFilter descriptionFieldFilter = (DescriptionFieldFilter)markerFieldFilter;
        if (descriptionFieldFilter.getContainsModifier().equals("CONTAINS")) {
            this.descriptionCombo.select(0);
        } else {
            this.descriptionCombo.select(1);
        }
        this.descriptionText.setText(descriptionFieldFilter.getContainsText());
    }

    private void createDescriptionGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.filtersDialog_descriptionLabel);
        this.descriptionCombo = new Combo(composite2, 8);
        this.descriptionCombo.add(MarkerMessages.filtersDialog_contains);
        this.descriptionCombo.add(MarkerMessages.filtersDialog_doesNotContain);
        this.descriptionCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        GC gC = new GC((Drawable)composite2);
        gC.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        this.descriptionText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)25);
        this.descriptionText.setLayoutData((Object)gridData);
    }

    public String getTitle() {
        return MarkerMessages.propertiesDialog_description_text;
    }
}

