/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Map;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.MarkerSupportConstants;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class DescriptionFieldFilter
extends CompatibilityFieldFilter {
    static final String TAG_CONTAINS_MODIFIER = "containsModifier";
    static final String TAG_CONTAINS_TEXT = "containsText";
    String containsModifier = "CONTAINS";
    String containsText = "";

    public void loadSettings(IMemento iMemento) {
        String string = iMemento.getString(TAG_CONTAINS_MODIFIER);
        if (string == null) {
            return;
        }
        String string2 = iMemento.getString(TAG_CONTAINS_TEXT);
        if (string2 == null) {
            return;
        }
        this.containsText = string2;
        this.containsModifier = string;
    }

    void loadLegacySettings(IMemento iMemento, MarkerContentGenerator markerContentGenerator) {
        String string = iMemento.getString("contains");
        if (string != null) {
            String string2 = this.containsModifier = Boolean.valueOf(string) != false ? "CONTAINS" : MarkerSupportConstants.DOES_NOT_CONTAIN_KEY;
        }
        if ((string = iMemento.getString("description")) != null) {
            this.containsText = new String(string);
        }
    }

    public void saveSettings(IMemento iMemento) {
        iMemento.putString(TAG_CONTAINS_MODIFIER, this.containsModifier);
        iMemento.putString(TAG_CONTAINS_TEXT, this.containsText);
    }

    public boolean select(MarkerItem markerItem) {
        if (this.containsText.length() == 0) {
            return true;
        }
        String string = this.getField().getValue(markerItem);
        if (this.containsModifier.equals("CONTAINS")) {
            return string.indexOf(this.containsText) >= 0;
        }
        return string.indexOf(this.containsText) < 0;
    }

    public void populateWorkingCopy(MarkerFieldFilter markerFieldFilter) {
        super.populateWorkingCopy(markerFieldFilter);
        DescriptionFieldFilter descriptionFieldFilter = (DescriptionFieldFilter)markerFieldFilter;
        descriptionFieldFilter.containsModifier = this.containsModifier;
        descriptionFieldFilter.containsText = this.containsText;
    }

    String getContainsModifier() {
        return this.containsModifier;
    }

    void setContainsModifier(String string) {
        this.containsModifier = string;
    }

    String getContainsText() {
        return this.containsText;
    }

    void setContainsText(String string) {
        this.containsText = string;
    }

    public void initialize(Map map) {
        super.initialize(map);
        if (map.containsKey("CONTAINS")) {
            this.setContainsText((String)map.get("CONTAINS"));
            this.setContainsModifier("CONTAINS");
        } else if (map.containsKey(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY)) {
            this.setContainsText((String)map.get(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY));
            this.setContainsModifier(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY);
        }
    }

    public void initialize(ProblemFilter problemFilter) {
        this.containsModifier = problemFilter.getContains() ? "CONTAINS" : MarkerSupportConstants.DOES_NOT_CONTAIN_KEY;
        this.containsText = problemFilter.getDescription();
    }
}

