/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.FiltersConfigurationDialog;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerColumnLabelProvider;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerCopyHandler;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerMap;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class ExtendedMarkersView
extends ViewPart {
    private static int instanceCount = 1;
    private static final String TAG_GENERATOR = "markerContentGenerator";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String MARKER_FIELD = "MARKER_FIELD";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_PART_NAME = "partName";
    private static final String TAG_COLUMN_WIDTHS = "columnWidths";
    private CachedMarkerBuilder builder;
    Collection categoriesToExpand;
    private Clipboard clipboard;
    Collection preservedSelection = new ArrayList();
    private Job updateJob;
    private MarkersTreeViewer viewer;
    private IPropertyChangeListener preferenceListener;
    private ISelectionListener pageSelectionListener;
    private IPartListener2 partListener;
    private IMemento memento;
    private String[] defaultGeneratorIds = new String[0];
    private IPropertyChangeListener workingSetListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        IAdapterFactory iAdapterFactory = new IAdapterFactory(){

            public Object getAdapter(Object object, Class clazz) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2 && object instanceof MarkerEntry) {
                    return ((MarkerEntry)object).getMarker();
                }
                return null;
            }

            public Class[] getAdapterList() {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                return classArray;
            }
        };
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.internal.views.markers.MarkerEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters(iAdapterFactory, (Class)clazz);
    }

    static String newSecondaryID(IViewPart iViewPart) {
        while (iViewPart.getSite().getPage().findViewReference(iViewPart.getSite().getId(), String.valueOf(instanceCount)) != null) {
            ++instanceCount;
        }
        return String.valueOf(instanceCount);
    }

    public static void openMarkerInEditor(IMarker iMarker, IWorkbenchPage iWorkbenchPage) {
        IEditorInput iEditorInput;
        IFile iFile;
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart != null && (iFile = ResourceUtil.getFile(iEditorInput = iEditorPart.getEditorInput())) != null && iMarker.getResource().equals((Object)iFile) && OpenStrategy.activateOnOpen()) {
            iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
        }
        if (iMarker != null && iMarker.getResource() instanceof IFile) {
            try {
                IDE.openEditor(iWorkbenchPage, iMarker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException partInitException) {
                iFile = partInitException.getStatus();
                if (iFile != null && iFile.getException() instanceof CoreException) {
                    iFile = ((CoreException)iFile.getException()).getStatus();
                }
                if (iFile == null) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(4, partInitException.getMessage(), (Throwable)partInitException), 2);
                }
                StatusManager.getManager().handle((IStatus)iFile, 2);
            }
        }
    }

    public ExtendedMarkersView(String string) {
        this.defaultGeneratorIds = new String[]{string};
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (string.equals("USE_MARKER_LIMITS") || string.equals("MARKER_LIMITS_VALUE")) {
                    ExtendedMarkersView.this.viewer.refresh();
                    ExtendedMarkersView.this.updateTitle();
                }
            }
        };
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    private void addAllConcreteItems(MarkerSupportItem markerSupportItem, Collection collection) {
        if (markerSupportItem.isConcrete()) {
            collection.add(markerSupportItem);
            return;
        }
        MarkerSupportItem[] markerSupportItemArray = markerSupportItem.getChildren();
        int n = 0;
        while (n < markerSupportItemArray.length) {
            this.addAllConcreteItems(markerSupportItemArray[n], collection);
            ++n;
        }
    }

    void addExpandedCategory(MarkerCategory markerCategory) {
        this.getCategoriesToExpand().add(markerCategory.getName());
    }

    private void addMarkers(MarkerSupportItem markerSupportItem, Collection collection) {
        if (markerSupportItem.getMarker() != null) {
            collection.add(markerSupportItem.getMarker());
        }
        MarkerSupportItem[] markerSupportItemArray = markerSupportItem.getChildren();
        int n = 0;
        while (n < markerSupportItemArray.length) {
            this.addMarkers(markerSupportItemArray[n], collection);
            ++n;
        }
    }

    private void createColumns(TreeColumn[] treeColumnArray) {
        Tree tree = this.viewer.getTree();
        TableLayout tableLayout = new TableLayout();
        MarkerField[] markerFieldArray = this.builder.getVisibleFields();
        IMemento iMemento = null;
        if (this.memento != null) {
            iMemento = this.memento.getChild(TAG_COLUMN_WIDTHS);
        }
        int n = 0;
        while (n < markerFieldArray.length) {
            Object object;
            TreeViewerColumn treeViewerColumn;
            MarkerField markerField = markerFieldArray[n];
            if (n < treeColumnArray.length) {
                treeViewerColumn = new TreeViewerColumn((TreeViewer)this.viewer, treeColumnArray[n]);
            } else {
                treeViewerColumn = new TreeViewerColumn((TreeViewer)this.viewer, 0);
                treeViewerColumn.getColumn().setResizable(true);
                treeViewerColumn.getColumn().setMoveable(true);
                treeViewerColumn.getColumn().addSelectionListener(this.getHeaderListener());
            }
            treeViewerColumn.getColumn().setData(MARKER_FIELD, (Object)markerField);
            treeViewerColumn.setLabelProvider((CellLabelProvider)new MarkerColumnLabelProvider(markerField));
            treeViewerColumn.getColumn().setText(markerField.getColumnHeaderText());
            treeViewerColumn.getColumn().setToolTipText(markerField.getColumnTooltipText());
            treeViewerColumn.getColumn().setImage(markerField.getColumnHeaderImage());
            EditingSupport editingSupport = markerField.getEditingSupport((ColumnViewer)this.viewer);
            if (editingSupport != null) {
                treeViewerColumn.setEditingSupport(editingSupport);
            }
            if (this.builder.getPrimarySortField().equals(markerField)) {
                this.updateDirectionIndicator(treeViewerColumn.getColumn(), markerField);
            }
            int n2 = -1;
            if (n == 0) {
                object = new GC((Drawable)tree);
                object.setFont(tree.getFont());
                FontMetrics fontMetrics = object.getFontMetrics();
                object.dispose();
                n2 = Math.max(markerField.getDefaultColumnWidth((Control)tree), fontMetrics.getAverageCharWidth() * 5);
            }
            if (iMemento != null && (object = iMemento.getInteger(this.getFieldId(treeViewerColumn.getColumn()))) != null && (Integer)object > 0) {
                n2 = (Integer)object;
            }
            if (n2 < 0) {
                tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(markerField.getDefaultColumnWidth((Control)tree), true, true));
            } else {
                tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(n2, true));
            }
            ++n;
        }
        if (treeColumnArray.length > markerFieldArray.length) {
            n = markerFieldArray.length;
            while (n < treeColumnArray.length) {
                treeColumnArray[n].dispose();
                ++n;
            }
        }
        this.viewer.getTree().setLayout((Layout)tableLayout);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.layout(true);
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.viewer = new MarkersTreeViewer(new Tree(composite, 66306));
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setUseHashlookup(true);
        this.createColumns(new TreeColumn[0]);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput(this.builder);
        if (this.memento != null) {
            Integer n;
            Scrollable scrollable = (Scrollable)this.viewer.getControl();
            ScrollBar scrollBar = scrollable.getVerticalBar();
            if (scrollBar != null && (n = this.memento.getInteger(TAG_VERTICAL_POSITION)) != null) {
                scrollBar.setSelection(n.intValue());
            }
            if ((scrollBar = scrollable.getHorizontalBar()) != null && (n = this.memento.getInteger(TAG_HORIZONTAL_POSITION)) != null) {
                scrollBar.setSelection(n.intValue());
            }
        }
        this.pageSelectionListener = this.getPageSelectionListener();
        this.getSite().getPage().addPostSelectionListener(this.pageSelectionListener);
        this.partListener = this.getPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
        this.pageSelectionListener.selectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.viewer){

            protected void activate(ISelection iSelection) {
                int n = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    ExtendedMarkersView.this.openSelectedMarkers();
                }
                finally {
                    OpenStrategy.setOpenMethod((int)n);
                }
            }

            protected void linkToEditor(ISelection iSelection) {
            }

            protected void open(ISelection iSelection, boolean bl) {
                ExtendedMarkersView.this.openSelectedMarkers();
            }
        };
        this.viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent treeEvent) {
                ExtendedMarkersView.this.removeExpandedCategory((MarkerCategory)treeEvent.item.getData());
            }

            public void treeExpanded(TreeEvent treeEvent) {
                ExtendedMarkersView.this.addExpandedCategory((MarkerCategory)treeEvent.item.getData());
            }
        });
        this.viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                Object object;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.help.IContextProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((object = ExtendedMarkersView.this.getAdapter(clazz)) == null) {
                    return;
                }
                IContext iContext = ((IContextProvider)object).getContext((Object)ExtendedMarkersView.this.viewer.getControl());
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(iContext);
            }
        });
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection iSelection = ExtendedMarkersView.this.viewer.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    ExtendedMarkersView.this.updateStatusLine((IStructuredSelection)ExtendedMarkersView.this.viewer.getSelection());
                }
            }
        });
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.getWorkingSetListener());
        this.registerContextMenu();
        this.initDragAndDrop();
    }

    void disableAllFilters() {
        this.builder.disableAllFilters();
    }

    public void dispose() {
        super.dispose();
        this.builder.dispose();
        this.updateJob.cancel();
        --instanceCount;
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        this.getSite().getPage().removePostSelectionListener(this.pageSelectionListener);
        this.getSite().getPage().removePartListener(this.partListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
    }

    MarkerSupportItem[] getAllConcreteItems() {
        MarkerSupportItem[] markerSupportItemArray = this.builder.getElements();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < markerSupportItemArray.length) {
            this.addAllConcreteItems(markerSupportItemArray[n], arrayList);
            ++n;
        }
        MarkerSupportItem[] markerSupportItemArray2 = new MarkerSupportItem[arrayList.size()];
        arrayList.toArray(markerSupportItemArray2);
        return markerSupportItemArray2;
    }

    Collection getAllFilters() {
        return this.builder.getAllFilters();
    }

    IMarker[] getAllMarkers() {
        MarkerSupportItem[] markerSupportItemArray = this.builder.getElements();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < markerSupportItemArray.length) {
            this.addMarkers(markerSupportItemArray[n], arrayList);
            ++n;
        }
        IMarker[] iMarkerArray = new IMarker[arrayList.size()];
        arrayList.toArray(iMarkerArray);
        return iMarkerArray;
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    private Collection getCategoriesToExpand() {
        if (this.categoriesToExpand == null) {
            IMemento iMemento;
            this.categoriesToExpand = new HashSet();
            if (this.memento != null && (iMemento = this.memento.getChild(TAG_EXPANDED)) != null) {
                IMemento[] iMementoArray = iMemento.getChildren(TAG_CATEGORY);
                MarkerCategory[] markerCategoryArray = this.builder.getCategories();
                if (markerCategoryArray != null) {
                    int n = 0;
                    while (n < markerCategoryArray.length) {
                        int n2 = 0;
                        while (n2 < iMementoArray.length) {
                            if (markerCategoryArray[n].getName().equals(iMementoArray[n2].getID())) {
                                this.categoriesToExpand.add(markerCategoryArray[n].getName());
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
            }
        }
        return this.categoriesToExpand;
    }

    MarkerGroup getCategoryGroup() {
        return this.builder.getCategoryGroup();
    }

    Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.viewer.getControl().getDisplay());
        }
        return this.clipboard;
    }

    private ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object object) {
                Object[] objectArray = ((MarkerSupportItem)object).getChildren();
                return this.getLimitedChildren(objectArray);
            }

            public Object[] getElements(Object object) {
                return this.getLimitedChildren(((CachedMarkerBuilder)object).getElements());
            }

            private Object[] getLimitedChildren(Object[] objectArray) {
                int n = MarkerSupportInternalUtilities.getMarkerLimit();
                if (n > 0 && n < objectArray.length) {
                    Object[] objectArray2 = new Object[n];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n);
                    return objectArray2;
                }
                return objectArray;
            }

            public Object getParent(Object object) {
                MarkerSupportItem markerSupportItem = ((MarkerSupportItem)object).getParent();
                if (markerSupportItem == null) {
                    return ExtendedMarkersView.this.builder;
                }
                return markerSupportItem;
            }

            public boolean hasChildren(Object object) {
                return ((MarkerSupportItem)object).getChildren().length > 0;
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        };
    }

    private String getFieldId(TreeColumn treeColumn) {
        return ((MarkerField)treeColumn.getData(MARKER_FIELD)).getConfigurationElement().getAttribute("id");
    }

    String[] getGeneratorIds() {
        return this.defaultGeneratorIds;
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeColumn treeColumn = (TreeColumn)selectionEvent.widget;
                MarkerField markerField = (MarkerField)treeColumn.getData(ExtendedMarkersView.MARKER_FIELD);
                ExtendedMarkersView.this.setPrimarySortField(markerField, treeColumn);
            }
        };
    }

    private ISelectionListener getPageSelectionListener() {
        return new ISelectionListener(){

            private ITaskListResourceAdapter getDefaultTaskListAdapter() {
                return new ITaskListResourceAdapter(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IResource getAffectedResource(IAdaptable iAdaptable) {
                        Object object;
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((object = iAdaptable.getAdapter((Class)clazz)) == null) {
                            Class<?> clazz2 = class$4;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$4 = Class.forName("org.eclipse.core.resources.IFile");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            object = iAdaptable.getAdapter((Class)clazz2);
                        }
                        if (object == null) {
                            return null;
                        }
                        return (IResource)object;
                    }
                };
            }

            public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                ArrayList<Object> arrayList;
                block16: {
                    block14: {
                        IFile iFile;
                        block15: {
                            Object object;
                            if (iWorkbenchPart == ExtendedMarkersView.this || !ExtendedMarkersView.this.getSite().getPage().isPartVisible(iWorkbenchPart)) {
                                return;
                            }
                            arrayList = new ArrayList<Object>();
                            if (!(iWorkbenchPart instanceof IEditorPart)) break block14;
                            IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
                            iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
                            if (iFile != null) break block15;
                            IEditorInput iEditorInput = iEditorPart.getEditorInput();
                            if (iEditorInput == null) break block16;
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = class$5 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((object = iEditorInput.getAdapter((Class)clazz)) == null) break block16;
                            arrayList.add(object);
                            break block16;
                        }
                        arrayList.add(iFile);
                        break block16;
                    }
                    if (iSelection instanceof IStructuredSelection) {
                        Iterator iterator = ((IStructuredSelection)iSelection).iterator();
                        while (iterator.hasNext()) {
                            Object object;
                            ITaskListResourceAdapter iTaskListResourceAdapter;
                            IResource iResource;
                            Object e = iterator.next();
                            if (!(e instanceof IAdaptable)) continue;
                            IAdaptable iAdaptable = (IAdaptable)e;
                            Class<?> clazz = class$6;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.ui.views.tasklist.ITaskListResourceAdapter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((iResource = (iTaskListResourceAdapter = (object = iAdaptable.getAdapter((Class)clazz)) != null && object instanceof ITaskListResourceAdapter ? (ITaskListResourceAdapter)object : this.getDefaultTaskListAdapter()).getAffectedResource((IAdaptable)e)) == null) {
                                Object object2;
                                IAdaptable iAdaptable2 = (IAdaptable)e;
                                Class<?> clazz2 = class$5;
                                if (clazz2 == null) {
                                    try {
                                        clazz2 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((object2 = iAdaptable2.getAdapter((Class)clazz2)) == null) continue;
                                arrayList.add(object2);
                                continue;
                            }
                            arrayList.add(iResource);
                        }
                    }
                }
                ExtendedMarkersView.this.builder.updateForNewSelection(arrayList.toArray());
            }
        };
    }

    private IPartListener2 getPartListener() {
        return new IPartListener2(){

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                if (iWorkbenchPartReference.getId().equals(ExtendedMarkersView.this.getSite().getId())) {
                    ExtendedMarkersView.this.pageSelectionListener.selectionChanged(ExtendedMarkersView.this.getSite().getPage().getActivePart(), ExtendedMarkersView.this.getSite().getPage().getSelection());
                }
            }
        };
    }

    public IMarker[] getSelectedMarkers() {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IMarker[] iMarkerArray;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
            while (iterator.hasNext()) {
                iMarkerArray = (IMarker[])iterator.next();
                if (!iMarkerArray.isConcrete()) continue;
                arrayList.add(((MarkerEntry)iMarkerArray).getMarker());
            }
            if (arrayList.isEmpty()) {
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
            }
            iMarkerArray = new IMarker[arrayList.size()];
            arrayList.toArray(iMarkerArray);
            return iMarkerArray;
        }
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
    }

    public boolean getSortAscending() {
        return this.viewer.getTree().getSortDirection() == 128;
    }

    private String getStatusMessage() {
        String string = "";
        int n = this.builder.getTotalMarkerCount();
        int n2 = 0;
        MarkerCategory[] markerCategoryArray = this.builder.getCategories();
        if (markerCategoryArray != null && this.builder.isShowingHierarchy()) {
            int n3 = MarkerSupportInternalUtilities.getMarkerLimit();
            int n4 = 0;
            while (n4 < markerCategoryArray.length) {
                n2 += n3 < 0 ? ((MarkerSupportItem)markerCategoryArray[n4]).getChildrenCount() : Math.min(((MarkerSupportItem)markerCategoryArray[n4]).getChildrenCount(), n3);
                ++n4;
            }
        } else {
            n2 = MarkerSupportInternalUtilities.getMarkerLimit();
        }
        Object[] objectArray = this.builder.getMarkerCounts();
        if (objectArray[0] == 0 && objectArray[1] == 0) {
            string = n2 < 0 || n2 >= n ? NLS.bind((String)MarkerMessages.filter_itemsMessage, (Object)new Integer(n)) : NLS.bind((String)MarkerMessages.filter_matchedMessage, (Object)new Integer(n2), (Object)new Integer(n));
            return string;
        }
        objectArray = new Integer[]{objectArray[0], objectArray[1], new Integer(objectArray[2] + objectArray[3])};
        if (n2 < 0 || n2 >= n) {
            return MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])objectArray);
        }
        return NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Object[]{MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])objectArray), new Integer(n2), new Integer(n)});
    }

    private Job getUpdateJob(final CachedMarkerBuilder cachedMarkerBuilder) {
        this.updateJob = new WorkbenchJob(MarkerMessages.MarkerView_queueing_updates){

            public boolean belongsTo(Object object) {
                return object == MarkerContentGenerator.CACHE_UPDATE_FAMILY;
            }

            private TreeViewer getViewer() {
                return ExtendedMarkersView.this.viewer;
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                Object object;
                if (ExtendedMarkersView.this.viewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (cachedMarkerBuilder.isShowingHierarchy() && ExtendedMarkersView.this.getCategoriesToExpand().isEmpty() && (object = cachedMarkerBuilder.getCategories()) != null && ((MarkerCategory[])object).length == 1) {
                    ExtendedMarkersView.this.getCategoriesToExpand().add(object[0].getDescription());
                }
                this.getViewer().refresh(true);
                ExtendedMarkersView.this.updateTitle();
                if (ExtendedMarkersView.this.preservedSelection.size() > 0) {
                    object = new ArrayList();
                    MarkerEntry[] markerEntryArray = cachedMarkerBuilder.getMarkerEntries();
                    int n = 0;
                    while (n < markerEntryArray.length) {
                        Iterator iterator = ExtendedMarkersView.this.preservedSelection.iterator();
                        while (iterator.hasNext()) {
                            MarkerSelectionEntry markerSelectionEntry = (MarkerSelectionEntry)iterator.next();
                            if (!markerSelectionEntry.isEquivalentTo(markerEntryArray[n])) continue;
                            object.add(markerEntryArray[n]);
                        }
                        ++n;
                    }
                    this.getViewer().setSelection((ISelection)new StructuredSelection(object.toArray()), true);
                    ExtendedMarkersView.this.preservedSelection.clear();
                }
                if (this.getViewer().getTree().getItemCount() > 0) {
                    this.getViewer().getTree().setTopItem(this.getViewer().getTree().getItem(0));
                }
                ExtendedMarkersView.this.reexpandCategories(cachedMarkerBuilder);
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !cachedMarkerBuilder.isBuilding() && IDEWorkbenchPlugin.getDefault().getBundle().getState() == 32;
            }
        };
        this.updateJob.setSystem(true);
        return this.updateJob;
    }

    Object getViewerInput() {
        return this.viewer.getInput();
    }

    MarkerField[] getVisibleFields() {
        return this.builder.getVisibleFields();
    }

    private IPropertyChangeListener getWorkingSetListener() {
        this.workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExtendedMarkersView.this.builder.scheduleMarkerUpdate();
            }
        };
        return this.workingSetListener;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        Object object;
        Class<?> clazz;
        super.init(iViewSite, iMemento);
        MarkerContentGenerator markerContentGenerator = null;
        if (iMemento != null) {
            markerContentGenerator = MarkerSupportRegistry.getInstance().getGenerator(iMemento.getString(TAG_GENERATOR));
        }
        if (markerContentGenerator == null && this.defaultGeneratorIds.length > 0 && (markerContentGenerator = MarkerSupportRegistry.getInstance().getGenerator(this.defaultGeneratorIds[0])) == null) {
            this.logInvalidGenerator(this.defaultGeneratorIds[0]);
        }
        if (markerContentGenerator == null) {
            markerContentGenerator = MarkerSupportRegistry.getInstance().getDefaultGenerator();
        }
        if ((clazz = class$7) == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService iMenuService = (IMenuService)iViewSite.getService((Class)clazz);
        iMenuService.populateContributionManager((ContributionManager)iViewSite.getActionBars().getMenuManager(), "menu:org.eclipse.ui.ide.MarkersView");
        iMenuService.populateContributionManager((ContributionManager)iViewSite.getActionBars().getToolBarManager(), "toolbar:org.eclipse.ui.ide.MarkersView");
        String string = iViewSite.getId();
        if (iViewSite.getSecondaryId() != null) {
            string = String.valueOf(string) + iViewSite.getSecondaryId();
        }
        this.builder = new CachedMarkerBuilder(markerContentGenerator, string, iMemento);
        this.builder.setUpdateJob(this.getUpdateJob(this.builder));
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((object = iViewSite.getAdapter((Class)clazz2)) != null) {
            this.builder.setProgressService((IWorkbenchSiteProgressService)object);
        }
        this.memento = iMemento;
        if (iMemento == null || iMemento.getString(TAG_PART_NAME) == null) {
            return;
        }
        this.setPartName(iMemento.getString(TAG_PART_NAME));
    }

    void initializeTitle(String string) {
        this.setPartName(string);
    }

    boolean isEnabled(MarkerFieldFilterGroup markerFieldFilterGroup) {
        return this.builder.getEnabledFilters().contains(markerFieldFilterGroup);
    }

    boolean isPrimarySortField(MarkerField markerField) {
        return this.builder.getPrimarySortField().equals(markerField);
    }

    boolean isShowing(MarkerContentGenerator markerContentGenerator) {
        return this.builder.getGenerator().equals(markerContentGenerator);
    }

    void logInvalidGenerator(String string) {
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui.ide", NLS.bind((String)"Invalid markerContentGenerator {0} ", (Object)string)));
    }

    void openFiltersDialog() {
        FiltersConfigurationDialog filtersConfigurationDialog = new FiltersConfigurationDialog((IShellProvider)new SameShellProvider((Control)this.getSite().getWorkbenchWindow().getShell()), this.builder);
        if (filtersConfigurationDialog.open() == 0) {
            this.builder.updateFrom(filtersConfigurationDialog);
        }
    }

    void openSelectedMarkers() {
        IMarker[] iMarkerArray = this.getSelectedMarkers();
        int n = 0;
        while (n < iMarkerArray.length) {
            IMarker iMarker = iMarkerArray[n];
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            ExtendedMarkersView.openMarkerInEditor(iMarker, iWorkbenchPage);
            ++n;
        }
    }

    void reexpandCategories(CachedMarkerBuilder cachedMarkerBuilder) {
        if (!this.getCategoriesToExpand().isEmpty() && cachedMarkerBuilder.isShowingHierarchy()) {
            MarkerSupportItem[] markerSupportItemArray = cachedMarkerBuilder.getElements();
            int n = 0;
            while (n < markerSupportItemArray.length) {
                String string = ((MarkerCategory)markerSupportItemArray[n]).getName();
                if (this.getCategoriesToExpand().contains(string)) {
                    this.viewer.expandToLevel(markerSupportItemArray[n], 2);
                }
                ++n;
            }
        }
    }

    private void registerContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        if (!this.getSite().getId().equals("org.eclipse.ui.ide.MarkersView")) {
            this.getSite().registerContextMenu("org.eclipse.ui.ide.MarkersView", menuManager, (ISelectionProvider)this.viewer);
        }
        Control control = this.viewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    void removeExpandedCategory(MarkerCategory markerCategory) {
        this.getCategoriesToExpand().remove(markerCategory.getName());
    }

    void saveSelection(ISelection iSelection) {
        this.preservedSelection.clear();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                MarkerSupportItem markerSupportItem = (MarkerSupportItem)iterator.next();
                if (markerSupportItem.isConcrete()) {
                    this.preservedSelection.add(new MarkerSelectionEntry(markerSupportItem));
                    this.getCategoriesToExpand().add(markerSupportItem.getParent());
                    continue;
                }
                this.getCategoriesToExpand().add(markerSupportItem);
            }
        }
    }

    public void saveState(IMemento iMemento) {
        MarkerField[] markerFieldArray;
        IMemento iMemento2;
        super.saveState(iMemento);
        iMemento.putString(TAG_GENERATOR, this.builder.getGenerator().getId());
        iMemento.putString(TAG_PART_NAME, this.getPartName());
        if (!this.getCategoriesToExpand().isEmpty()) {
            iMemento2 = iMemento.createChild(TAG_EXPANDED);
            markerFieldArray = this.getCategoriesToExpand().iterator();
            while (markerFieldArray.hasNext()) {
                iMemento2.createChild(TAG_CATEGORY, (String)markerFieldArray.next());
            }
        }
        iMemento2 = iMemento.createChild(TAG_COLUMN_WIDTHS);
        markerFieldArray = new MarkerField[this.viewer.getTree().getColumnCount()];
        int[] nArray = this.viewer.getTree().getColumnOrder();
        int n = 0;
        while (n < markerFieldArray.length) {
            TreeColumn treeColumn = this.viewer.getTree().getColumn(n);
            iMemento2.putInteger(this.getFieldId(treeColumn), treeColumn.getWidth());
            markerFieldArray[nArray[n]] = (MarkerField)treeColumn.getData(MARKER_FIELD);
            ++n;
        }
        this.builder.saveState(iMemento, markerFieldArray);
    }

    void selectAll() {
        this.viewer.getTree().selectAll();
    }

    void setCategoryGroup(MarkerGroup markerGroup) {
        this.getCategoriesToExpand().clear();
        this.builder.setCategoryGroup(markerGroup);
    }

    void setContentGenerator(MarkerContentGenerator markerContentGenerator) {
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.removeAndClearAll();
        this.builder.setGenerator(markerContentGenerator);
        this.createColumns(this.viewer.getTree().getColumns());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void setPrimarySortField(MarkerField markerField) {
        TreeColumn[] treeColumnArray = this.viewer.getTree().getColumns();
        int n = 0;
        while (n < treeColumnArray.length) {
            TreeColumn treeColumn = treeColumnArray[n];
            if (treeColumnArray[n].getData(MARKER_FIELD).equals(markerField)) {
                this.setPrimarySortField(markerField, treeColumn);
                return;
            }
            ++n;
        }
        StatusManager.getManager().handle(StatusUtil.newStatus(2, "Sorting by non visible field " + markerField.getColumnHeaderText(), null));
    }

    private void setPrimarySortField(MarkerField markerField, TreeColumn treeColumn) {
        this.builder.setPrimarySortField(markerField);
        IViewSite iViewSite = this.getViewSite();
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchSiteProgressService iWorkbenchSiteProgressService = (IWorkbenchSiteProgressService)iViewSite.getAdapter((Class)clazz);
        this.builder.refreshContents(iWorkbenchSiteProgressService);
        this.updateDirectionIndicator(treeColumn, markerField);
        this.viewer.refresh();
        this.reexpandCategories(this.builder);
    }

    void setSelection(StructuredSelection structuredSelection, boolean bl) {
        ArrayList<MarkerItem> arrayList = new ArrayList<MarkerItem>(structuredSelection.size());
        Iterator iterator = structuredSelection.iterator();
        while (iterator.hasNext()) {
            MarkerItem markerItem;
            Object e = iterator.next();
            if (!(e instanceof IMarker) || (markerItem = this.builder.getMarkerItem((IMarker)e)) == null) continue;
            arrayList.add(markerItem);
        }
        iterator = new StructuredSelection(arrayList);
        this.viewer.setSelection((ISelection)iterator, bl);
        this.updateStatusLine((IStructuredSelection)iterator);
    }

    void toggleFilter(MarkerFieldFilterGroup markerFieldFilterGroup) {
        this.builder.toggleFilter(markerFieldFilterGroup);
    }

    void toggleSortDirection() {
        this.setPrimarySortField(this.builder.getPrimarySortField());
    }

    void updateDirectionIndicator(TreeColumn treeColumn, MarkerField markerField) {
        this.viewer.getTree().setSortColumn(treeColumn);
        if (this.builder.getSortDirection(markerField) == 1) {
            this.viewer.getTree().setSortDirection(128);
        } else {
            this.viewer.getTree().setSortDirection(1024);
        }
    }

    private void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string;
        if (iStructuredSelection == null || iStructuredSelection.size() == 0) {
            string = "";
        } else if (iStructuredSelection.size() == 1) {
            string = ((MarkerSupportItem)iStructuredSelection.getFirstElement()).getDescription();
        } else {
            Object object;
            Iterator iterator = iStructuredSelection.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                object = (MarkerSupportItem)iterator.next();
                if (!((MarkerSupportItem)object).isConcrete()) continue;
                arrayList.add(object);
            }
            object = new MarkerEntry[arrayList.size()];
            arrayList.toArray((T[])object);
            MarkerMap markerMap = new MarkerMap((MarkerEntry[])object);
            string = this.getStatusSummary(markerMap);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    private String getStatusSummary(MarkerMap markerMap) {
        Object[] objectArray = markerMap.getMarkerCounts();
        if ((objectArray = new Integer[]{objectArray[0], objectArray[1], new Integer(objectArray[2] + objectArray[3])})[0] == 0 && objectArray[1] == 0) {
            return MessageFormat.format((String)MarkerMessages.marker_statusSelectedCount, (Object[])new Object[]{new Integer(markerMap.getSize())});
        }
        return MessageFormat.format((String)MarkerMessages.marker_statusSummarySelected, (Object[])new Object[]{new Integer(markerMap.getSize()), MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])objectArray)});
    }

    void updateTitle() {
        this.setContentDescription(this.getStatusMessage());
    }

    private void initDragAndDrop() {
        int n = 1;
        Transfer[] transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter dragSourceAdapter = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                ExtendedMarkersView.this.performDragSetData(dragSourceEvent);
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }
        };
        this.viewer.addDragSupport(n, transferArray, (DragSourceListener)dragSourceAdapter);
    }

    private void performDragSetData(DragSourceEvent dragSourceEvent) {
        IMarker[] iMarkerArray;
        if (MarkerTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = this.getSelectedMarkers();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType) && (iMarkerArray = this.getSelectedMarkers()) != null) {
            dragSourceEvent.data = MarkerCopyHandler.createMarkerReport(this, iMarkerArray);
        }
    }

    Object[] getHiddenFields() {
        return this.builder.getHiddenFields();
    }

    void setVisibleFields(Collection collection) {
        this.builder.setVisibleFields(collection);
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.removeAndClearAll();
        this.createColumns(this.viewer.getTree().getColumns());
        this.viewer.refresh();
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    final class MarkerSelectionEntry {
        Object[] cachedValues;

        MarkerSelectionEntry(MarkerItem markerItem) {
            MarkerField[] markerFieldArray = ExtendedMarkersView.this.builder.getVisibleFields();
            this.cachedValues = new Object[markerFieldArray.length];
            int n = 0;
            while (n < markerFieldArray.length) {
                this.cachedValues[n] = markerFieldArray[n].getValue(markerItem);
                ++n;
            }
        }

        boolean isEquivalentTo(MarkerItem markerItem) {
            MarkerField[] markerFieldArray = ExtendedMarkersView.this.builder.getVisibleFields();
            if (this.cachedValues.length != markerFieldArray.length) {
                return false;
            }
            int n = 0;
            while (n < markerFieldArray.length) {
                if (this.cachedValues[n] != markerFieldArray[n].getValue(markerItem)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

