/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.ScopeArea;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class FiltersConfigurationDialog
extends Dialog {
    private static final String SELECTED_FILTER_GROUP = "SELECTED_FILTER_GROUP";
    private Collection filterGroups;
    private CheckboxTableViewer filtersList;
    private GroupFilterConfigurationArea scopeArea = new ScopeArea();
    private MarkerFieldFilterGroup selectedFilterGroup;
    private ScrolledForm form;
    private CachedMarkerBuilder builder;
    private Collection filterAreas;
    private boolean andFilters = false;
    private Button removeButton;
    private Button cloneButton;

    public FiltersConfigurationDialog(IShellProvider iShellProvider, CachedMarkerBuilder cachedMarkerBuilder) {
        super(iShellProvider);
        this.filterGroups = this.makeWorkingCopy(cachedMarkerBuilder.getAllFilters());
        this.builder = cachedMarkerBuilder;
        this.andFilters = cachedMarkerBuilder.andFilters();
    }

    boolean andFilters() {
        return this.andFilters;
    }

    public boolean close() {
        this.saveDialogSettings();
        return super.close();
    }

    protected Control createDialogArea(Composite composite) {
        composite.getShell().setText(MarkerMessages.configureFiltersDialog_title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        this.createFilterSelectionArea(composite2);
        final FormToolkit formToolkit = new FormToolkit(composite2.getDisplay());
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                formToolkit.dispose();
            }
        });
        this.form = formToolkit.createScrolledForm(composite2);
        this.form.setBackground(composite.getBackground());
        GridData gridData = new GridData(4, 4, true, true);
        this.form.setLayoutData((Object)gridData);
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.filterAreas = this.builder.createFilterConfigurationFields();
        this.createFieldArea(formToolkit, this.form, this.scopeArea, true);
        Iterator iterator = this.filterAreas.iterator();
        while (iterator.hasNext()) {
            this.createFieldArea(formToolkit, this.form, (FilterConfigurationArea)iterator.next(), true);
        }
        if (this.filterGroups.isEmpty()) {
            this.setFieldsEnabled(false);
        } else {
            this.loadDialogSettings();
        }
        FiltersConfigurationDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createFieldArea(FormToolkit formToolkit, ScrolledForm scrolledForm, FilterConfigurationArea filterConfigurationArea, boolean bl) {
        final ExpandableComposite expandableComposite = formToolkit.createExpandableComposite(scrolledForm.getBody(), 2);
        expandableComposite.setText(filterConfigurationArea.getTitle());
        expandableComposite.setBackground(scrolledForm.getBackground());
        expandableComposite.setLayout((Layout)new GridLayout());
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, filterConfigurationArea.grabExcessVerticalSpace()));
        expandableComposite.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                expandableComposite.getParent().layout(true);
            }

            public void expansionStateChanging(ExpansionEvent expansionEvent) {
            }
        });
        Composite composite = formToolkit.createComposite((Composite)expandableComposite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        composite.setBackground(scrolledForm.getBackground());
        filterConfigurationArea.createContents(composite);
        expandableComposite.setClient((Control)composite);
        expandableComposite.setExpanded(bl);
    }

    private void createFilterSelectionArea(Composite composite) {
        MarkerFieldFilterGroup markerFieldFilterGroup;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.filtersDialog_entriesTitle);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.filtersList = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2048);
        this.filtersList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return FiltersConfigurationDialog.this.filterGroups.toArray();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.filtersList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((MarkerFieldFilterGroup)object).getName();
            }
        });
        if (this.selectedFilterGroup != null) {
            this.filtersList.setSelection((ISelection)new StructuredSelection((Object)this.selectedFilterGroup));
        }
        this.filtersList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                FiltersConfigurationDialog.this.setSelectedFilter((MarkerFieldFilterGroup)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement());
            }
        });
        this.filtersList.setInput((Object)this);
        Iterator iterator = this.filterGroups.iterator();
        while (iterator.hasNext()) {
            markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            this.filtersList.setChecked((Object)markerFieldFilterGroup, markerFieldFilterGroup.isEnabled());
        }
        markerFieldFilterGroup = new GridData(4, 4, true, true);
        ((GridData)markerFieldFilterGroup).widthHint = this.convertHorizontalDLUsToPixels(100);
        this.filtersList.getControl().setLayoutData((Object)markerFieldFilterGroup);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 1;
        composite3.setLayoutData((Object)gridData2);
        Button button = new Button(composite3, 8);
        button.setText(MarkerMessages.MarkerFilter_addFilterName);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersConfigurationDialog.this.addNewFilter(false);
            }
        });
        this.setButtonLayoutData(button);
        this.cloneButton = new Button(composite3, 8);
        this.cloneButton.setText(MarkerMessages.MarkerFilter_cloneFilterName);
        this.cloneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersConfigurationDialog.this.addNewFilter(true);
            }
        });
        this.setButtonLayoutData(this.cloneButton);
        this.removeButton = new Button(composite3, 8);
        this.removeButton.setText(MarkerMessages.MarkerFilter_deleteSelectedName);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersConfigurationDialog.this.removeFilters(FiltersConfigurationDialog.this.filtersList.getSelection());
            }
        });
        this.setButtonLayoutData(this.removeButton);
        Button button2 = new Button(composite2, 16);
        GridData gridData3 = new GridData(768, 0, true, false);
        gridData3.horizontalSpan = 2;
        button2.setLayoutData((Object)gridData3);
        button2.setText(MarkerMessages.AND_Title);
        button2.setSelection(this.andFilters);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersConfigurationDialog.this.andFilters = true;
            }
        });
        Button button3 = new Button(composite2, 16);
        gridData3 = new GridData(768, 0, true, false);
        gridData3.horizontalSpan = 2;
        button3.setLayoutData((Object)gridData3);
        button3.setText(MarkerMessages.OR_Title);
        button3.setSelection(!this.andFilters);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersConfigurationDialog.this.andFilters = false;
            }
        });
    }

    private void addNewFilter(boolean bl) {
        String string;
        InputDialog inputDialog = new InputDialog(this.getShell(), MarkerMessages.MarkerFilterDialog_title, MarkerMessages.MarkerFilterDialog_message, MarkerMessages.MarkerFilter_newFilterName, new IInputValidator(){

            public String isValid(String string) {
                if (string.length() == 0) {
                    return MarkerMessages.MarkerFilterDialog_emptyMessage;
                }
                Iterator iterator = FiltersConfigurationDialog.this.filterGroups.iterator();
                while (iterator.hasNext()) {
                    if (!((MarkerFieldFilterGroup)iterator.next()).getName().equals(string)) continue;
                    return NLS.bind((String)MarkerMessages.filtersDialog_conflictingName, (Object)string);
                }
                return null;
            }
        });
        if (inputDialog.open() == 0 && (string = inputDialog.getValue()) != null) {
            this.createNewFilter(string, bl);
        }
    }

    private void createNewFilter(String string, boolean bl) {
        MarkerFieldFilterGroup markerFieldFilterGroup = new MarkerFieldFilterGroup(null, this.builder);
        if (bl && this.selectedFilterGroup != null) {
            this.captureStateInto(markerFieldFilterGroup);
        }
        markerFieldFilterGroup.setName(string);
        this.filterGroups.add(markerFieldFilterGroup);
        this.filtersList.refresh();
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object)markerFieldFilterGroup));
        this.filtersList.setChecked((Object)markerFieldFilterGroup, true);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(((Object)((Object)this)).getClass().getName());
        if (iDialogSettings == null) {
            iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return iDialogSettings;
    }

    Collection getFilters() {
        return this.filterGroups;
    }

    protected boolean isResizable() {
        return true;
    }

    private void loadDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        String string = iDialogSettings.get(SELECTED_FILTER_GROUP);
        if (string != null) {
            Iterator iterator = this.filterGroups.iterator();
            while (iterator.hasNext()) {
                MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
                if (!markerFieldFilterGroup.getName().equals(string)) continue;
                this.filtersList.setSelection((ISelection)new StructuredSelection((Object)markerFieldFilterGroup));
                return;
            }
        }
        this.filtersList.setSelection((ISelection)new StructuredSelection(this.filterGroups.iterator().next()));
    }

    private Collection makeWorkingCopy(Collection collection) {
        Iterator iterator = collection.iterator();
        ArrayList<MarkerFieldFilterGroup> arrayList = new ArrayList<MarkerFieldFilterGroup>(collection.size());
        while (iterator.hasNext()) {
            MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            MarkerFieldFilterGroup markerFieldFilterGroup2 = markerFieldFilterGroup.makeWorkingCopy();
            if (markerFieldFilterGroup2 == null) continue;
            arrayList.add(markerFieldFilterGroup2);
        }
        return arrayList;
    }

    protected void okPressed() {
        if (!this.shouldContinue()) {
            return;
        }
        Iterator iterator = this.filterGroups.iterator();
        while (iterator.hasNext()) {
            MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            markerFieldFilterGroup.setEnabled(this.filtersList.getChecked((Object)markerFieldFilterGroup));
        }
        this.captureStateInto(this.selectedFilterGroup);
        super.okPressed();
    }

    private void captureStateInto(MarkerFieldFilterGroup markerFieldFilterGroup) {
        if (markerFieldFilterGroup != null) {
            this.scopeArea.applyToGroup(markerFieldFilterGroup);
            Iterator iterator = this.filterAreas.iterator();
            while (iterator.hasNext()) {
                FilterConfigurationArea filterConfigurationArea = (FilterConfigurationArea)iterator.next();
                if (filterConfigurationArea instanceof GroupFilterConfigurationArea) {
                    ((GroupFilterConfigurationArea)filterConfigurationArea).applyToGroup(markerFieldFilterGroup);
                }
                filterConfigurationArea.apply(markerFieldFilterGroup.getFilter(filterConfigurationArea.getField()));
            }
        }
    }

    private boolean shouldContinue() {
        if (this.filtersList.getCheckedElements().length == 0) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)MarkerMessages.filtersDialogDeselectedFiltersTitle, (String)MarkerMessages.filtersDialogDeselectedFiltersMessage);
        }
        return true;
    }

    private void removeFilters(ISelection iSelection) {
        this.filterGroups.remove(((IStructuredSelection)iSelection).getFirstElement());
        this.filtersList.refresh();
    }

    private void saveDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (this.selectedFilterGroup != null) {
            iDialogSettings.put(SELECTED_FILTER_GROUP, this.selectedFilterGroup.getName());
        }
    }

    private void setEnabled(boolean bl, Control control) {
        control.setEnabled(bl);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.setEnabled(bl, controlArray[n]);
                ++n;
            }
        }
    }

    private void setFieldsEnabled(boolean bl) {
        this.setEnabled(bl, (Control)this.form);
    }

    private void setSelectedFilter(MarkerFieldFilterGroup markerFieldFilterGroup) {
        this.removeButton.setEnabled(markerFieldFilterGroup != null && !markerFieldFilterGroup.isSystem());
        this.cloneButton.setEnabled(markerFieldFilterGroup != null);
        MarkerFieldFilterGroup markerFieldFilterGroup2 = this.selectedFilterGroup;
        this.selectedFilterGroup = markerFieldFilterGroup;
        if (markerFieldFilterGroup2 != null) {
            this.scopeArea.applyToGroup(markerFieldFilterGroup2);
        }
        if (this.selectedFilterGroup == null) {
            this.setFieldsEnabled(false);
            return;
        }
        this.setFieldsEnabled(true);
        this.scopeArea.initializeFromGroup(this.selectedFilterGroup);
        Iterator iterator = this.filterAreas.iterator();
        while (iterator.hasNext()) {
            FilterConfigurationArea filterConfigurationArea = (FilterConfigurationArea)iterator.next();
            if (markerFieldFilterGroup2 != null) {
                if (filterConfigurationArea instanceof GroupFilterConfigurationArea) {
                    ((GroupFilterConfigurationArea)filterConfigurationArea).applyToGroup(markerFieldFilterGroup2);
                }
                filterConfigurationArea.apply(markerFieldFilterGroup2.getFilter(filterConfigurationArea.getField()));
            }
            if (filterConfigurationArea instanceof GroupFilterConfigurationArea) {
                ((GroupFilterConfigurationArea)filterConfigurationArea).initializeFromGroup(this.selectedFilterGroup);
            }
            filterConfigurationArea.initialize(this.selectedFilterGroup.getFilter(filterConfigurationArea.getField()));
        }
    }
}

