/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkersContribution;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class GroupsContribution
extends MarkersContribution {
    protected IContributionItem[] getContributionItems() {
        Collection collection = this.getView().getBuilder().getGenerator().getMarkerGroups();
        if (collection.isEmpty()) {
            return new IContributionItem[0];
        }
        Iterator iterator = collection.iterator();
        IContributionItem[] iContributionItemArray = new IContributionItem[collection.size() + 1];
        int n = 0;
        while (n < iContributionItemArray.length - 1) {
            MarkerGroup markerGroup = (MarkerGroup)iterator.next();
            iContributionItemArray[n] = this.getContributionItem(markerGroup);
            ++n;
        }
        iContributionItemArray[iContributionItemArray.length - 1] = this.getContributionItem(null);
        return iContributionItemArray;
    }

    private IContributionItem getContributionItem(final MarkerGroup markerGroup) {
        return new ContributionItem(){

            public void fill(Menu menu, int n) {
                MenuItem menuItem = new MenuItem(menu, 16);
                menuItem.setText(markerGroup == null ? MarkerMessages.ProblemView_None : markerGroup.getMarkerField().getColumnHeaderText());
                ExtendedMarkersView extendedMarkersView = GroupsContribution.this.getView();
                menuItem.addListener(13, this.getMenuItemListener(markerGroup, extendedMarkersView));
                if (extendedMarkersView != null) {
                    if (markerGroup == null) {
                        menuItem.setSelection(extendedMarkersView.getCategoryGroup() == null);
                    } else {
                        menuItem.setSelection(markerGroup.equals(extendedMarkersView.getCategoryGroup()));
                    }
                }
            }

            private Listener getMenuItemListener(MarkerGroup markerGroup2, ExtendedMarkersView extendedMarkersView) {
                return new Listener(this, extendedMarkersView, markerGroup2){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ExtendedMarkersView val$view;
                    private final /* synthetic */ MarkerGroup val$group;
                    {
                        this.this$1 = var1_1;
                        this.val$view = extendedMarkersView;
                        this.val$group = markerGroup;
                    }

                    public void handleEvent(Event event) {
                        MenuItem menuItem = (MenuItem)event.widget;
                        if (menuItem.getSelection() && this.val$view != null) {
                            this.val$view.setCategoryGroup(this.val$group);
                        }
                    }
                };
            }
        };
    }
}

