/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkCompletedHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent executionEvent) {
        final ExecutionEvent executionEvent2 = executionEvent;
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(MarkerMessages.markCompletedHandler_task, 100);
                    IMarker[] iMarkerArray = MarkCompletedHandler.this.getSelectedMarkers(executionEvent2);
                    if (iMarkerArray.length == 0) {
                        return;
                    }
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("done", Boolean.TRUE);
                    UpdateMarkersOperation updateMarkersOperation = new UpdateMarkersOperation(iMarkerArray, hashMap, MarkerMessages.markCompletedAction_title, true);
                    iProgressMonitor.worked(20);
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    MarkCompletedHandler.this.execute((IUndoableOperation)updateMarkersOperation, MarkerMessages.markCompletedAction_title, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 80), null);
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException), 1);
        }
        catch (InterruptedException interruptedException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(2, interruptedException.getLocalizedMessage(), (Throwable)interruptedException), 1);
        }
        return this;
    }
}

