/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class MarkerCategory
extends MarkerSupportItem {
    int start;
    int end;
    private MarkerEntry[] children;
    private String name;
    private CachedMarkerBuilder cachedMarkerBuilder;
    private int severity = -1;

    MarkerCategory(CachedMarkerBuilder cachedMarkerBuilder, int n, int n2, String string) {
        this.cachedMarkerBuilder = cachedMarkerBuilder;
        this.start = n;
        this.end = n2;
        this.name = string;
    }

    MarkerSupportItem[] getChildren() {
        if (this.children == null) {
            if (this.cachedMarkerBuilder.isBuilding()) {
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
            }
            MarkerEntry[] markerEntryArray = this.cachedMarkerBuilder.getMarkerEntries();
            int n = this.getChildrenCount();
            this.children = new MarkerEntry[n];
            System.arraycopy(markerEntryArray, this.start, this.children, 0, n);
            int n2 = 0;
            while (n2 < this.children.length) {
                this.children[n2].setCategory(this);
                ++n2;
            }
        }
        return this.children;
    }

    int getChildrenCount() {
        return this.end - this.start + 1;
    }

    String getDescription() {
        int n = this.getChildrenCount();
        int n2 = MarkerSupportInternalUtilities.getMarkerLimit();
        if (n2 > 0 && n > n2) {
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(MarkerSupportInternalUtilities.getMarkerLimit()), String.valueOf(this.getChildrenCount())});
        }
        if (n == 1) {
            return NLS.bind((String)MarkerMessages.Category_One_Item_Label, (Object[])new Object[]{this.name});
        }
        return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(n)});
    }

    int getHighestSeverity() {
        if (this.severity >= 0) {
            return this.severity;
        }
        this.severity = 0;
        MarkerSupportItem[] markerSupportItemArray = this.getChildren();
        int n = 0;
        while (n < markerSupportItemArray.length) {
            if (markerSupportItemArray[n].isConcrete()) {
                int n2 = markerSupportItemArray[n].getAttributeValue("severity", -1);
                if (n2 > this.severity) {
                    this.severity = n2;
                }
                if (this.severity == 2) {
                    return this.severity;
                }
            }
            ++n;
        }
        return this.severity;
    }

    String getName() {
        return this.name;
    }

    MarkerSupportItem getParent() {
        return null;
    }

    boolean isConcrete() {
        return false;
    }
}

