/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

class MarkerComparator
implements Comparator {
    private MarkerField category;
    private MarkerField[] fields;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private static final String PRIMARY_SORT_FIELD_TAG = "PRIMARY_SORT_FIELD";
    private static final String DESCENDING_FIELDS = "DESCENDING_FIELDS";
    HashSet descendingFields = new HashSet();

    public MarkerComparator(MarkerField markerField, MarkerField[] markerFieldArray) {
        this.category = markerField;
        this.fields = markerFieldArray;
    }

    public int compareCategory(Object object, Object object2) {
        if (this.category == null) {
            return 0;
        }
        return this.category.compare((MarkerItem)object, (MarkerItem)object2);
    }

    public int compare(Object object, Object object2) {
        int n;
        MarkerItem markerItem = (MarkerItem)object;
        MarkerItem markerItem2 = (MarkerItem)object2;
        if (this.category != null && (n = this.category.compare(markerItem, markerItem2)) != 0) {
            return n;
        }
        n = 0;
        while (n < this.fields.length) {
            int n2 = this.descendingFields.contains(this.fields[n]) ? this.fields[n].compare(markerItem2, markerItem) : this.fields[n].compare(markerItem, markerItem2);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public void reversePriority(MarkerField markerField) {
        if (this.descendingFields.remove(markerField)) {
            return;
        }
        this.descendingFields.add(markerField);
    }

    void setPrimarySortField(MarkerField markerField) {
        if (this.fields[0] == markerField) {
            this.reversePriority(markerField);
            return;
        }
        int n = 1;
        MarkerField[] markerFieldArray = new MarkerField[this.fields.length];
        markerFieldArray[0] = markerField;
        int n2 = 0;
        while (n2 < markerFieldArray.length) {
            if (this.fields[n2] != markerField) {
                markerFieldArray[n] = this.fields[n2];
                ++n;
            }
            ++n2;
        }
        this.fields = markerFieldArray;
    }

    void restore(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        String string = iMemento.getString(PRIMARY_SORT_FIELD_TAG);
        if (string == null || string.equals(MarkerSupportInternalUtilities.getId(this.fields[0]))) {
            return;
        }
        int n = 1;
        while (n < this.fields.length) {
            if (MarkerSupportInternalUtilities.getId(this.fields[n]).equals(string)) {
                this.setPrimarySortField(this.fields[n]);
                break;
            }
            ++n;
        }
        IMemento[] iMementoArray = iMemento.getChildren(DESCENDING_FIELDS);
        int n2 = 0;
        while (n2 < this.fields.length) {
            int n3 = 0;
            while (n3 < iMementoArray.length) {
                if (iMementoArray[n3].getID().equals(MarkerSupportInternalUtilities.getId(this.fields[n2]))) {
                    this.descendingFields.add(this.fields[n2]);
                }
                ++n3;
            }
            ++n2;
        }
    }

    void saveState(IMemento iMemento) {
        iMemento.putString(PRIMARY_SORT_FIELD_TAG, MarkerSupportInternalUtilities.getId(this.fields[0]));
        Iterator iterator = this.descendingFields.iterator();
        while (iterator.hasNext()) {
            iMemento.createChild(DESCENDING_FIELDS, MarkerSupportInternalUtilities.getId((MarkerField)iterator.next()));
        }
    }

    MarkerField getPrimarySortField() {
        return this.fields[0];
    }

    void setCategory(MarkerField markerField) {
        this.category = markerField;
    }
}

