/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerCompletionField
extends MarkerField {
    static final String COMPLETE_IMAGE_PATH = "$nl$/icons/full/obj16/complete_tsk.gif";
    static final String INCOMPLETE_IMAGE_PATH = "$nl$/icons/full/obj16/incomplete_tsk.gif";
    private static final int DONE = 2;
    private static final int NOT_DONE = 1;
    private static final int UNDEFINED = 0;

    public int compare(MarkerItem markerItem, MarkerItem markerItem2) {
        return this.getDoneConstant(markerItem2) - this.getDoneConstant(markerItem);
    }

    public String getColumnHeaderText() {
        return "";
    }

    public String getColumnTooltipText() {
        return MarkerMessages.completion_description;
    }

    private Image getCompleteImage() {
        return MarkerSupportInternalUtilities.createImage(COMPLETE_IMAGE_PATH, this.getImageManager());
    }

    public int getDefaultColumnWidth(Control control) {
        return 40;
    }

    private int getDoneConstant(MarkerItem markerItem) {
        int n = 0;
        if (markerItem.getMarker() != null && markerItem.getAttributeValue("userEditable", true)) {
            n = 1;
            if (markerItem.getAttributeValue("done", false)) {
                n = 2;
            }
        }
        return n;
    }

    public EditingSupport getEditingSupport(ColumnViewer columnViewer) {
        return new CompletionEditingSupport(columnViewer);
    }

    private Image getImage(Object object) {
        switch (this.getDoneConstant((MarkerItem)object)) {
            case 2: {
                return this.getCompleteImage();
            }
            case 1: {
                return MarkerSupportInternalUtilities.createImage(INCOMPLETE_IMAGE_PATH, this.getImageManager());
            }
        }
        return null;
    }

    public String getValue(MarkerItem markerItem) {
        return "";
    }

    public void update(ViewerCell viewerCell) {
        super.update(viewerCell);
        viewerCell.setImage(this.getImage(viewerCell.getElement()));
    }

    private class CompletionEditingSupport
    extends EditingSupport {
        private CheckboxCellEditor editor;

        public CompletionEditingSupport(ColumnViewer columnViewer) {
            super(columnViewer);
            this.editor = new CheckboxCellEditor((Composite)columnViewer.getControl());
        }

        protected boolean canEdit(Object object) {
            if (object instanceof MarkerEntry) {
                return ((MarkerEntry)object).getAttributeValue("userEditable", false);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            return new Boolean(((MarkerEntry)object).getAttributeValue("done", false));
        }

        protected void setValue(Object object, Object object2) {
            MarkerEntry markerEntry = (MarkerEntry)object;
            Boolean bl = (Boolean)object2;
            try {
                markerEntry.getMarker().setAttribute("done", bl.booleanValue());
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
            }
        }
    }
}

