/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerMap;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerContentGenerator {
    private static final String ATTRIBUTE_DEFAULT_MARKER_GROUPING = "defaultMarkerGrouping";
    private static final String ATTRIBUTE_VISIBLE = "visible";
    public static final Object CACHE_UPDATE_FAMILY = new Object();
    private static final String ELEMENT_MARKER_FIELD_CONFIGURATION = "markerFieldConfiguration";
    private static final IResource[] EMPTY_RESOURCE_ARRAY = new IResource[0];
    private static final String MARKER_FIELD_REFERENCE = "markerFieldReference";
    private MarkerField[] allFields;
    private IConfigurationElement configurationElement;
    private Collection markerTypes;
    private MarkerField[] initialVisible;
    private Collection groups;
    private Collection generatorExtensions = new ArrayList();
    private Map allTypesTable;
    static /* synthetic */ Class class$0;

    public MarkerContentGenerator(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
    }

    private void addDefinedGroups(Collection collection) {
        this.addGroupsFrom(this.configurationElement, collection);
        Iterator iterator = this.generatorExtensions.iterator();
        while (iterator.hasNext()) {
            this.addGroupsFrom((IConfigurationElement)iterator.next(), collection);
        }
    }

    public void addExtensions(Collection collection) {
        this.generatorExtensions = collection;
    }

    private void addGroupsFrom(IConfigurationElement iConfigurationElement, Collection collection) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("markerGrouping");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            collection.add(MarkerGroup.createMarkerGroup(iConfigurationElementArray[n]));
            ++n;
        }
    }

    boolean allTypesSelected(Collection collection) {
        return collection.containsAll(this.markerTypes);
    }

    private Collection computeAllMarkers(SubProgressMonitor subProgressMonitor) {
        HashSet hashSet = new HashSet();
        this.findMarkers(hashSet, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, null, 2, (IProgressMonitor)subProgressMonitor);
        return hashSet;
    }

    private void computeMarkers(Collection collection, SubProgressMonitor subProgressMonitor, MarkerFieldFilterGroup markerFieldFilterGroup, IResource[] iResourceArray) {
        int n = markerFieldFilterGroup.getScope();
        markerFieldFilterGroup.refresh();
        switch (n) {
            case 0: {
                this.findMarkers(collection, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, markerFieldFilterGroup, 2, (IProgressMonitor)subProgressMonitor);
                break;
            }
            case 1: {
                this.findMarkers(collection, iResourceArray, markerFieldFilterGroup, 0, (IProgressMonitor)subProgressMonitor);
                break;
            }
            case 2: {
                this.findMarkers(collection, iResourceArray, markerFieldFilterGroup, 2, (IProgressMonitor)subProgressMonitor);
                break;
            }
            case 3: {
                this.findMarkers(collection, this.getProjects(iResourceArray), markerFieldFilterGroup, 2, (IProgressMonitor)subProgressMonitor);
                break;
            }
            case 4: {
                this.findMarkers(collection, this.getResourcesInWorkingSet(markerFieldFilterGroup.getWorkingSet()), markerFieldFilterGroup, 2, (IProgressMonitor)subProgressMonitor);
            }
        }
    }

    private void filterMarkers(Collection collection, MarkerFieldFilterGroup markerFieldFilterGroup, IMarker[] iMarkerArray) {
        int n = 0;
        while (n < iMarkerArray.length) {
            IMarker iMarker = iMarkerArray[n];
            if (markerFieldFilterGroup == null || markerFieldFilterGroup.select(iMarker)) {
                collection.add(iMarker);
            }
            ++n;
        }
    }

    private void findIntersection(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            hashSet.add(e);
        }
        collection2.removeAll(hashSet);
    }

    /*
     * Unable to fully structure code
     */
    private void findMarkers(Collection var1_1, IResource[] var2_2, MarkerFieldFilterGroup var3_3, int var4_4, IProgressMonitor var5_5) {
        if (var2_2 == null) {
            return;
        }
        var6_6 = this.getMarkerTypes();
        var7_7 = new HashSet<E>(var6_6.size());
        var8_8 = new HashSet<Object>(var6_6.size());
        var7_7.addAll(var6_6);
        var9_9 = var6_6.iterator();
        while (var9_9.hasNext()) {
            var10_10 = (MarkerType)var9_9.next();
            var11_11 = Arrays.asList(var10_10.getAllSubTypes());
            if (!var6_6.containsAll(var11_11)) continue;
            var7_7.removeAll(var11_11);
            var8_8.add(var10_10);
        }
        var5_5.beginTask(MarkerMessages.MarkerFilter_searching, var7_7.size() * var2_2.length);
        var10_10 = new HashSet<E>();
        var11_12 = 0;
        while (var11_12 < var2_2.length) {
            var12_13 = var2_2[var11_12];
            if (var12_13.exists()) {
                if (var10_10.contains(var12_13)) {
                    var5_5.worked(var7_7.size());
                } else {
                    var10_10.add(var12_13);
                }
            }
            ++var11_12;
        }
        var11_12 = 0;
        while (var11_12 < var2_2.length) {
            block12: {
                var9_9 = var7_7.iterator();
                var12_13 = var2_2[var11_12];
                if (!var12_13.isAccessible()) break block12;
                if (var4_4 != 2) ** GOTO lbl54
                var13_14 = var12_13.getParent();
                var14_15 = false;
                while (var13_14 != null) {
                    if (var10_10.contains(var13_14)) {
                        var14_15 = true;
                    }
                    var13_14 = var13_14.getParent();
                }
                if (!var14_15) ** GOTO lbl54
                break block12;
lbl-1000:
                // 1 sources

                {
                    var13_14 = (MarkerType)var9_9.next();
                    try {
                        var14_16 = var12_13.findMarkers(var13_14.getId(), var8_8.contains(var13_14), var4_4);
                        var5_5.worked(1);
                        this.filterMarkers(var1_1, var3_3, var14_16);
                        continue;
                    }
                    catch (CoreException var14_17) {
                        Policy.handle(var14_17);
                    }
lbl54:
                    // 4 sources

                    ** while (var9_9.hasNext())
                }
            }
            ++var11_12;
        }
        var5_5.done();
    }

    MarkerMap generateFilteredMarkers(SubProgressMonitor subProgressMonitor, boolean bl, IResource[] iResourceArray, Collection collection) {
        Object object;
        MarkerEntry[] markerEntryArray;
        HashSet hashSet = null;
        if (collection.size() > 0) {
            markerEntryArray = collection.iterator();
            if (bl) {
                object = new HashSet();
                while (markerEntryArray.hasNext()) {
                    this.computeMarkers((Collection)object, subProgressMonitor, (MarkerFieldFilterGroup)markerEntryArray.next(), iResourceArray);
                    if (hashSet == null) {
                        hashSet = new HashSet(object);
                    } else {
                        this.findIntersection((Collection)object, hashSet);
                    }
                    object.clear();
                }
            } else {
                hashSet = new HashSet();
                while (markerEntryArray.hasNext()) {
                    this.computeMarkers(hashSet, subProgressMonitor, (MarkerFieldFilterGroup)markerEntryArray.next(), iResourceArray);
                }
            }
        } else {
            hashSet = this.computeAllMarkers(subProgressMonitor);
        }
        markerEntryArray = new MarkerEntry[hashSet.size()];
        object = hashSet.iterator();
        int n = 0;
        while (object.hasNext()) {
            markerEntryArray[n] = new MarkerEntry((IMarker)object.next());
            ++n;
        }
        return new MarkerMap(markerEntryArray);
    }

    MarkerField[] getAllFields() {
        return this.allFields;
    }

    String getCategoryName() {
        return this.configurationElement.getAttribute(ATTRIBUTE_DEFAULT_MARKER_GROUPING);
    }

    IConfigurationElement[] getFilterReferences() {
        int n;
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = this.configurationElement.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
        if (this.generatorExtensions.isEmpty()) {
            return iConfigurationElementArray2;
        }
        Iterator iterator = this.generatorExtensions.iterator();
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        while (iterator.hasNext()) {
            iConfigurationElementArray = (IConfigurationElement[])iterator.next();
            object = iConfigurationElementArray.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
            n = 0;
            while (n < ((IConfigurationElement[])object).length) {
                arrayList.add(object[n]);
                ++n;
            }
        }
        if (arrayList.size() > 0) {
            iConfigurationElementArray = new IConfigurationElement[iConfigurationElementArray2.length + arrayList.size()];
            System.arraycopy(iConfigurationElementArray2, 0, iConfigurationElementArray, 0, iConfigurationElementArray2.length);
            object = arrayList.iterator();
            n = iConfigurationElementArray2.length;
            while (object.hasNext()) {
                iConfigurationElementArray[n] = (IConfigurationElement)object.next();
            }
            return iConfigurationElementArray;
        }
        return iConfigurationElementArray2;
    }

    public String getId() {
        return this.configurationElement.getAttribute("id");
    }

    MarkerField[] getInitialVisible() {
        return this.initialVisible;
    }

    MarkerGroup getMarkerGroup(String string) {
        Iterator iterator = this.getMarkerGroups().iterator();
        while (iterator.hasNext()) {
            MarkerGroup markerGroup = (MarkerGroup)iterator.next();
            if (!markerGroup.getId().equals(string)) continue;
            return markerGroup;
        }
        return null;
    }

    Collection getMarkerGroups() {
        if (this.groups == null) {
            this.groups = new HashSet();
            this.addDefinedGroups(this.groups);
            if (this.getId().equals("org.eclipse.ui.ide.problemsGenerator")) {
                this.groups.addAll(MarkerSupportRegistry.getInstance().getMarkerGroups());
            }
        }
        return this.groups;
    }

    public Collection getMarkerTypes() {
        if (this.markerTypes == null) {
            this.markerTypes = new HashSet();
            IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren("markerTypeReference");
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("id");
                MarkerType[] markerTypeArray = MarkerTypesModel.getInstance().getType(string).getAllSubTypes();
                int n2 = 0;
                while (n2 < markerTypeArray.length) {
                    this.markerTypes.add(markerTypeArray[n2]);
                    ++n2;
                }
                this.markerTypes.add(MarkerTypesModel.getInstance().getType(string));
                ++n;
            }
            if (this.markerTypes.isEmpty()) {
                MarkerType[] markerTypeArray = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker").getAllSubTypes();
                int n3 = 0;
                while (n3 < markerTypeArray.length) {
                    this.markerTypes.add(markerTypeArray[n3]);
                    ++n3;
                }
            }
        }
        return this.markerTypes;
    }

    String getName() {
        return this.configurationElement.getAttribute("name");
    }

    private IResource[] getProjects(IResource[] iResourceArray) {
        if (iResourceArray.length == 0) {
            return EMPTY_RESOURCE_ARRAY;
        }
        HashSet<IProject> hashSet = new HashSet<IProject>();
        int n = 0;
        while (n < iResourceArray.length) {
            hashSet.add(iResourceArray[n].getProject());
            ++n;
        }
        if (hashSet.isEmpty()) {
            return EMPTY_RESOURCE_ARRAY;
        }
        return hashSet.toArray(new IResource[hashSet.size()]);
    }

    private IResource[] getResourcesInWorkingSet(IWorkingSet iWorkingSet) {
        if (iWorkingSet == null) {
            return new IResource[0];
        }
        if (iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty() && ((AggregateWorkingSet)iWorkingSet).getComponents().length == 0) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iAdaptableArray.length);
        int n = 0;
        while (n < iAdaptableArray.length) {
            IResource iResource;
            IAdaptable iAdaptable = iAdaptableArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    MarkerType getType(String string) {
        Map map = this.getTypesTable();
        if (map.containsKey(string)) {
            return (MarkerType)map.get(string);
        }
        return null;
    }

    private Map getTypesTable() {
        if (this.allTypesTable == null) {
            this.allTypesTable = new HashMap();
            Iterator iterator = this.markerTypes.iterator();
            while (iterator.hasNext()) {
                MarkerType markerType = (MarkerType)iterator.next();
                this.allTypesTable.put(markerType.getId(), markerType);
            }
        }
        return this.allTypesTable;
    }

    public void initializeFromConfigurationElement(MarkerSupportRegistry markerSupportRegistry) {
        IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren(MARKER_FIELD_REFERENCE);
        ArrayList<MarkerField> arrayList = new ArrayList<MarkerField>();
        ArrayList<MarkerField> arrayList2 = new ArrayList<MarkerField>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            MarkerField markerField = markerSupportRegistry.getField(iConfigurationElementArray[n].getAttribute("id"));
            if (markerField != null) {
                arrayList.add(markerField);
                if (!MarkerSupportInternalUtilities.VALUE_FALSE.equals(iConfigurationElementArray[n].getAttribute(ATTRIBUTE_VISIBLE))) {
                    arrayList2.add(markerField);
                }
            }
            ++n;
        }
        this.allFields = new MarkerField[arrayList.size()];
        arrayList.toArray(this.allFields);
        this.initialVisible = new MarkerField[arrayList2.size()];
        arrayList2.toArray(this.initialVisible);
    }

    public void removeExtension(IConfigurationElement iConfigurationElement) {
        this.generatorExtensions.remove(iConfigurationElement);
    }
}

