/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;

public class MarkerCopyHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent executionEvent) {
        MarkerSupportView markerSupportView = this.getView(executionEvent);
        if (markerSupportView == null) {
            return null;
        }
        this.setClipboard(markerSupportView);
        return this;
    }

    private void setClipboard(ExtendedMarkersView extendedMarkersView) {
        Transfer[] transferArray;
        Object[] objectArray;
        IMarker[] iMarkerArray = extendedMarkersView.getSelectedMarkers();
        String string = MarkerCopyHandler.createMarkerReport(extendedMarkersView, iMarkerArray);
        if (string == null) {
            objectArray = new Object[]{iMarkerArray};
            transferArray = new Transfer[]{MarkerTransfer.getInstance()};
        } else {
            objectArray = new Object[]{iMarkerArray, string};
            transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        }
        extendedMarkersView.getClipboard().setContents(objectArray, transferArray);
    }

    static String createMarkerReport(ExtendedMarkersView extendedMarkersView, IMarker[] iMarkerArray) {
        StringBuffer stringBuffer = new StringBuffer();
        MarkerField[] markerFieldArray = extendedMarkersView.getVisibleFields();
        String string = System.getProperty("line.separator");
        int n = 0;
        while (n < markerFieldArray.length) {
            stringBuffer.append(markerFieldArray[n].getColumnHeaderText());
            if (n == markerFieldArray.length - 1) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('\t');
            }
            ++n;
        }
        n = 0;
        while (n < iMarkerArray.length) {
            int n2 = 0;
            while (n2 < markerFieldArray.length) {
                stringBuffer.append(markerFieldArray[n2].getValue(MarkerSupportInternalUtilities.newMarkerItem(iMarkerArray[n])));
                if (n2 == markerFieldArray.length - 1) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append('\t');
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

