/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.CollationKey;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerDescriptionField
extends MarkerField {
    public int compare(MarkerItem markerItem, MarkerItem markerItem2) {
        return this.getDescriptionKey(markerItem).compareTo(this.getDescriptionKey(markerItem2));
    }

    public int getDefaultColumnWidth(Control control) {
        return 50 * MarkerSupportInternalUtilities.getFontWidth(control);
    }

    private CollationKey getDescriptionKey(Object object) {
        if (object instanceof MarkerEntry) {
            return ((MarkerEntry)object).getCollationKey("message", "");
        }
        return MarkerSupportInternalUtilities.EMPTY_COLLATION_KEY;
    }

    public String getValue(MarkerItem markerItem) {
        return markerItem.getAttributeValue("message", "");
    }

    public EditingSupport getEditingSupport(ColumnViewer columnViewer) {
        return new DescriptionEditingSupport(columnViewer);
    }

    private class DescriptionEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public DescriptionEditingSupport(ColumnViewer columnViewer) {
            super(columnViewer);
            this.editor = new TextCellEditor((Composite)columnViewer.getControl());
        }

        protected boolean canEdit(Object object) {
            if (object instanceof MarkerEntry) {
                MarkerEntry markerEntry = (MarkerEntry)object;
                try {
                    if (markerEntry.getMarker() != null && markerEntry.getMarker().isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    Policy.handle(coreException);
                    return false;
                }
                return markerEntry.getAttributeValue("userEditable", false);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            return ((MarkerEntry)object).getAttributeValue("message", "");
        }

        protected void setValue(Object object, Object object2) {
            MarkerEntry markerEntry = (MarkerEntry)object;
            try {
                markerEntry.getMarker().setAttribute("message", object2);
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
            }
        }
    }
}

