/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

class MarkerEntry
extends MarkerSupportItem
implements IAdaptable {
    private static final Object LOCATION_STRING = "LOCATION_STRING";
    Map attributeCache = new HashMap(0);
    private MarkerCategory category;
    Map collationKeys = null;
    private String folder;
    IMarker marker;
    static /* synthetic */ Class class$0;

    public MarkerEntry(IMarker iMarker) {
        this.marker = iMarker;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.marker;
        }
        return null;
    }

    public boolean getAttributeValue(String string, boolean bl) {
        Object object = this.getAttributeValue(string);
        if (object == null) {
            return bl;
        }
        return (Boolean)object;
    }

    public int getAttributeValue(String string, int n) {
        Object object = this.getAttributeValue(string);
        if (object == null) {
            return n;
        }
        return (Integer)object;
    }

    private Object getAttributeValue(String string) {
        Object object;
        if (this.attributeCache.containsKey(string)) {
            object = this.attributeCache.get(string);
        } else {
            try {
                object = this.marker.getAttribute(string);
            }
            catch (CoreException coreException) {
                object = null;
            }
            this.attributeCache.put(string, object);
        }
        return object;
    }

    public String getAttributeValue(String string, String string2) {
        Object object = this.getAttributeValue(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    MarkerCategory getCategory() {
        return this.category;
    }

    MarkerSupportItem[] getChildren() {
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
    }

    CollationKey getCollationKey(String string, String string2) {
        if (this.collationKeys != null && this.collationKeys.containsKey(string)) {
            return (CollationKey)this.collationKeys.get(string);
        }
        String string3 = this.getAttributeValue(string, string2);
        if (string3.length() == 0) {
            return MarkerSupportInternalUtilities.EMPTY_COLLATION_KEY;
        }
        CollationKey collationKey = Collator.getInstance().getCollationKey(string3);
        if (this.collationKeys == null) {
            this.collationKeys = new HashMap(2);
        }
        this.collationKeys.put(string, collationKey);
        return collationKey;
    }

    long getCreationTime() {
        try {
            return this.marker.getCreationTime();
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return -1L;
        }
    }

    String getDescription() {
        return this.getAttributeValue("message", "");
    }

    long getID() {
        return this.marker.getId();
    }

    public String getLocation() {
        if (this.attributeCache.containsKey(LOCATION_STRING)) {
            return (String)this.attributeCache.get(LOCATION_STRING);
        }
        String string = this.getAttributeValue("location", "");
        if (string.length() > 0) {
            this.attributeCache.put(LOCATION_STRING, string);
            return string;
        }
        int n = this.getAttributeValue("lineNumber", -1);
        String string2 = n < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(n));
        this.attributeCache.put(LOCATION_STRING, string2);
        return string2;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    String getMarkerTypeName() {
        try {
            return MarkerTypesModel.getInstance().getType(this.marker.getType()).getLabel();
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
        }
    }

    MarkerSupportItem getParent() {
        return this.category;
    }

    public String getPath() {
        if (this.folder == null) {
            Object object;
            if (!this.marker.exists()) {
                return super.getPath();
            }
            try {
                object = this.marker.getAttribute("org.eclipse.ui.views.markers.path");
                if (object != null) {
                    this.folder = object.toString();
                    return this.folder;
                }
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
            }
            object = this.marker.getResource().getFullPath();
            int n = object.segmentCount() - 1;
            if (n <= 0) {
                return super.getPath();
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += object.segment(n3).length();
                ++n3;
            }
            if (n > 1) {
                n2 += n - 1;
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            int n4 = 0;
            while (n4 < n) {
                if (n4 != 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(object.segment(n4));
                ++n4;
            }
            this.folder = stringBuffer.toString();
        }
        return this.folder;
    }

    boolean isConcrete() {
        return true;
    }

    void setCategory(MarkerCategory markerCategory) {
        this.category = markerCategory;
    }

    void setMarker(IMarker iMarker) {
        this.marker = iMarker;
        this.attributeCache.clear();
    }

    void clearCaches() {
        this.collationKeys = null;
        this.attributeCache.clear();
    }
}

