/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerTypeFieldFilter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FiltersContributionParameters;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerFieldFilter;

class MarkerFieldFilterGroup {
    private static final String ATTRIBUTE_ON_ANY_IN_SAME_CONTAINER = "ON_ANY_IN_SAME_CONTAINER";
    private static final String ATTRIBUTE_ON_SELECTED_AND_CHILDREN = "ON_SELECTED_AND_CHILDREN";
    private static final String ATTRIBUTE_ON_SELECTED_ONLY = "ON_SELECTED_ONLY";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String ATTRIBUTE_VALUES = "values";
    private static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    static final int ON_ANY = 0;
    static final int ON_ANY_IN_SAME_CONTAINER = 3;
    static final int ON_SELECTED_AND_CHILDREN = 2;
    static final int ON_SELECTED_ONLY = 1;
    static final int ON_WORKING_SET = 4;
    static final String TAG_ENABLED = "enabled";
    private static final String TAG_SCOPE = "scope";
    private static final String TAG_FIELD_FILTER_ENTRY = "fieldFilter";
    private static final String TAG_WORKING_SET = "workingSet";
    private static String USER = "USER";
    protected CachedMarkerBuilder builder;
    private IConfigurationElement element;
    private Map EMPTY_MAP = new HashMap();
    private boolean enabled = true;
    protected MarkerFieldFilter[] fieldFilters;
    private int scope;
    private String name;
    private String id;
    private MarkerEntry testEntry = new MarkerEntry(null);
    private IWorkingSet workingSet;
    private IResource[] wSetResources;
    static /* synthetic */ Class class$0;

    static IProject[] getProjects(IResource[] iResourceArray) {
        if (iResourceArray == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        Collection collection = MarkerFieldFilterGroup.getProjectsAsCollection(iResourceArray);
        return collection.toArray(new IProject[collection.size()]);
    }

    static Collection getProjectsAsCollection(Object[] objectArray) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                hashSet.add(((IResource)objectArray[n]).getProject());
            } else {
                IProject[] iProjectArray = ((ResourceMapping)objectArray[n]).getProjects();
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    hashSet.add(iProjectArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public MarkerFieldFilterGroup(IConfigurationElement iConfigurationElement, CachedMarkerBuilder cachedMarkerBuilder) {
        this.element = iConfigurationElement;
        this.builder = cachedMarkerBuilder;
        this.initializeWorkingSet();
        this.scope = this.processScope();
        if (iConfigurationElement == null) {
            return;
        }
        String string = iConfigurationElement.getAttribute(TAG_ENABLED);
        if ("false".equals(string)) {
            this.enabled = false;
        }
    }

    Collection getAllTypes() {
        return this.builder.getGenerator().getMarkerTypes();
    }

    private MarkerFieldFilter[] getFieldFilters() {
        if (this.fieldFilters == null) {
            this.calculateFilters();
        }
        return this.fieldFilters;
    }

    protected void calculateFilters() {
        Map map = this.getValues();
        ArrayList<MarkerFieldFilter> arrayList = new ArrayList<MarkerFieldFilter>();
        MarkerField[] markerFieldArray = this.builder.getVisibleFields();
        int n = 0;
        while (n < markerFieldArray.length) {
            MarkerFieldFilter markerFieldFilter = MarkerSupportInternalUtilities.generateFilter(markerFieldArray[n]);
            if (markerFieldFilter != null) {
                arrayList.add(markerFieldFilter);
                if (markerFieldFilter instanceof MarkerTypeFieldFilter) {
                    ((MarkerTypeFieldFilter)markerFieldFilter).setContentGenerator(this.builder.getGenerator());
                }
                if (map != null) {
                    markerFieldFilter.initialize(map);
                }
            }
            ++n;
        }
        this.fieldFilters = new MarkerFieldFilter[arrayList.size()];
        arrayList.toArray(this.fieldFilters);
    }

    public MarkerFieldFilter getFilter(MarkerField markerField) {
        MarkerFieldFilter[] markerFieldFilterArray = this.getFieldFilters();
        int n = 0;
        while (n < markerFieldFilterArray.length) {
            if (markerFieldFilterArray[n].getField().equals(markerField)) {
                return markerFieldFilterArray[n];
            }
            ++n;
        }
        return null;
    }

    public String getID() {
        if (this.id == null) {
            this.id = this.element == null ? String.valueOf(USER) + String.valueOf(System.currentTimeMillis()) : this.element.getAttribute("name");
        }
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.element == null ? "" : this.element.getAttribute("name");
        }
        return this.name;
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        if (this.workingSet.isAggregateWorkingSet() && this.workingSet.isEmpty() && ((AggregateWorkingSet)this.workingSet).getComponents().length == 0) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] iAdaptableArray = this.workingSet.getElements();
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iAdaptableArray.length);
        int n = 0;
        while (n < iAdaptableArray.length) {
            IResource iResource;
            IAdaptable iAdaptable = iAdaptableArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public int getScope() {
        return this.scope;
    }

    private Map getValues() {
        try {
            String string = null;
            if (this.element != null && (string = this.element.getAttribute(ATTRIBUTE_VALUES)) != null) {
                FiltersContributionParameters filtersContributionParameters = (FiltersContributionParameters)IDEWorkbenchPlugin.createExtension(this.element, ATTRIBUTE_VALUES);
                return filtersContributionParameters.getParameterValues();
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return null;
        }
        return this.EMPTY_MAP;
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    private void computeWorkingSetResources() {
        if (this.workingSet != null) {
            this.wSetResources = this.getResourcesInWorkingSet();
        }
    }

    private boolean isInWorkingSet(IResource iResource) {
        if (this.wSetResources == null) {
            this.computeWorkingSetResources();
        }
        int n = 0;
        while (n < this.wSetResources.length) {
            if (this.wSetResources[n].getFullPath().isPrefixOf(iResource.getFullPath())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void initializeWorkingSet() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            this.setWorkingSet(iWorkbenchPage.getAggregateWorkingSet());
            if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT")) {
                this.setScope(4);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSystem() {
        return this.element != null;
    }

    void legacyLoadSettings(IMemento iMemento) {
        MarkerFieldFilter[] markerFieldFilterArray;
        String string;
        Integer n;
        String string2 = iMemento.getString(TAG_ENABLED);
        if (string2 != null && string2.length() > 0) {
            this.enabled = Boolean.valueOf(string2);
        }
        if ((n = iMemento.getInteger("onResource")) != null) {
            this.scope = n;
        }
        if ((string = iMemento.getString(TAG_WORKING_SET)) != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string));
        }
        if (this.element == null) {
            String string3;
            markerFieldFilterArray = iMemento.getID();
            if (markerFieldFilterArray != null && markerFieldFilterArray.length() > 0) {
                this.name = markerFieldFilterArray;
            }
            if ((string3 = iMemento.getString("IMemento.internal.id")) != null && string3.length() > 0) {
                this.id = string3;
            }
        }
        markerFieldFilterArray = this.getFieldFilters();
        int n2 = 0;
        while (n2 < markerFieldFilterArray.length) {
            if (markerFieldFilterArray[n2] instanceof CompatibilityFieldFilter) {
                ((CompatibilityFieldFilter)markerFieldFilterArray[n2]).loadLegacySettings(iMemento, this.builder.getGenerator());
            }
            ++n2;
        }
    }

    void loadSettings(IMemento iMemento) {
        Object object;
        String string = iMemento.getString(TAG_ENABLED);
        if (string != null && string.length() > 0) {
            this.enabled = Boolean.valueOf(string);
        }
        this.scope = iMemento.getInteger("scope");
        String string2 = iMemento.getString(TAG_WORKING_SET);
        if (string2 != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string2));
        }
        HashMap<String, MarkerFieldFilter> hashMap = new HashMap<String, MarkerFieldFilter>();
        MarkerFieldFilter[] markerFieldFilterArray = this.getFieldFilters();
        int n = 0;
        while (n < markerFieldFilterArray.length) {
            hashMap.put(MarkerSupportInternalUtilities.getId(markerFieldFilterArray[n].getField()), markerFieldFilterArray[n]);
            ++n;
        }
        IMemento[] iMementoArray = iMemento.getChildren(TAG_FIELD_FILTER_ENTRY);
        int n2 = 0;
        while (n2 < iMementoArray.length) {
            object = iMementoArray[n2];
            String string3 = object.getID();
            if (hashMap.containsKey(string3)) {
                MarkerFieldFilter markerFieldFilter = (MarkerFieldFilter)hashMap.get(string3);
                if (markerFieldFilter instanceof MarkerTypeFieldFilter) {
                    ((MarkerTypeFieldFilter)markerFieldFilter).setContentGenerator(this.builder.getGenerator());
                }
                markerFieldFilter.loadSettings((IMemento)object);
            }
            ++n2;
        }
        if (this.element == null) {
            String string4 = iMemento.getString("name");
            if (string4 != null && string4.length() > 0) {
                this.name = string4;
            }
            if ((object = iMemento.getString("IMemento.internal.id")) != null && ((String)object).length() > 0) {
                this.id = object;
            }
        }
    }

    MarkerFieldFilterGroup makeWorkingCopy() {
        MarkerFieldFilterGroup markerFieldFilterGroup = new MarkerFieldFilterGroup(this.element, this.builder);
        if (this.populateClone(markerFieldFilterGroup)) {
            return markerFieldFilterGroup;
        }
        return null;
    }

    protected boolean populateClone(MarkerFieldFilterGroup markerFieldFilterGroup) {
        markerFieldFilterGroup.scope = this.scope;
        markerFieldFilterGroup.workingSet = this.workingSet;
        markerFieldFilterGroup.enabled = this.enabled;
        markerFieldFilterGroup.fieldFilters = new MarkerFieldFilter[this.getFieldFilters().length];
        markerFieldFilterGroup.name = this.name;
        markerFieldFilterGroup.id = this.id;
        int n = 0;
        while (n < this.fieldFilters.length) {
            try {
                markerFieldFilterGroup.fieldFilters[n] = (MarkerFieldFilter)this.fieldFilters[n].getClass().newInstance();
                this.fieldFilters[n].populateWorkingCopy(markerFieldFilterGroup.fieldFilters[n]);
            }
            catch (InstantiationException instantiationException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, instantiationException.getLocalizedMessage(), (Throwable)instantiationException), 2);
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, illegalAccessException.getLocalizedMessage(), (Throwable)illegalAccessException), 2);
                return false;
            }
            ++n;
        }
        return true;
    }

    private int processScope() {
        if (this.element == null) {
            return 0;
        }
        String string = this.element.getAttribute("scope");
        if (string.equals(ATTRIBUTE_ON_SELECTED_ONLY)) {
            return 1;
        }
        if (string.equals(ATTRIBUTE_ON_SELECTED_AND_CHILDREN)) {
            return 2;
        }
        if (string.equals(ATTRIBUTE_ON_ANY_IN_SAME_CONTAINER)) {
            return 3;
        }
        return 0;
    }

    void saveFilterSettings(IMemento iMemento) {
        iMemento.putString(TAG_ENABLED, String.valueOf(this.enabled));
        iMemento.putString("scope", String.valueOf(this.scope));
        if (this.workingSet != null) {
            iMemento.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
        if (this.element == null) {
            iMemento.putString("name", this.getName());
            iMemento.putString("IMemento.internal.id", this.getID());
        }
        MarkerFieldFilter[] markerFieldFilterArray = this.getFieldFilters();
        int n = 0;
        while (n < markerFieldFilterArray.length) {
            IMemento iMemento2 = iMemento.createChild(TAG_FIELD_FILTER_ENTRY, MarkerSupportInternalUtilities.getId(markerFieldFilterArray[n].getField()));
            markerFieldFilterArray[n].saveSettings(iMemento2);
            ++n;
        }
    }

    public boolean select(IMarker iMarker) {
        MarkerFieldFilter[] markerFieldFilterArray = this.getFieldFilters();
        this.testEntry.setMarker(iMarker);
        if (this.scope == 4 && this.workingSet != null && (!this.workingSet.isAggregateWorkingSet() ? !this.isInWorkingSet(iMarker.getResource()) : ((AggregateWorkingSet)this.workingSet).getComponents().length != 0 && !this.isInWorkingSet(iMarker.getResource()))) {
            return false;
        }
        int n = 0;
        while (n < markerFieldFilterArray.length) {
            if (!markerFieldFilterArray[n].select(this.testEntry)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    void setWorkingSet(IWorkingSet iWorkingSet) {
        this.workingSet = iWorkingSet;
    }

    void refresh() {
        this.computeWorkingSetResources();
    }
}

