/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.views.markers.MarkerItem;

class MarkerMap {
    static final MarkerMap EMPTY_MAP = new MarkerMap();
    private MarkerEntry[] markers;
    private Map markerToEntryMap = null;
    private Integer[] markerCounts;

    public MarkerMap() {
        this(new MarkerEntry[0]);
    }

    public MarkerMap(MarkerEntry[] markerEntryArray) {
        this.markers = markerEntryArray;
    }

    public MarkerEntry elementAt(int n) {
        return this.markers[n];
    }

    Integer[] getMarkerCounts() {
        if (this.markerCounts == null) {
            int[] nArray = new int[4];
            int n = 0;
            while (n < this.markers.length) {
                MarkerEntry markerEntry = this.markers[n];
                int n2 = markerEntry.getAttributeValue("severity", -1);
                if (n2 >= 0) {
                    int n3 = markerEntry.getAttributeValue("severity", -1);
                    nArray[n3] = nArray[n3] + 1;
                } else {
                    nArray[3] = nArray[3] + 1;
                }
                ++n;
            }
            this.markerCounts = new Integer[]{new Integer(nArray[2]), new Integer(nArray[1]), new Integer(nArray[0]), new Integer(nArray[3])};
        }
        return this.markerCounts;
    }

    public MarkerItem getMarkerItem(IMarker iMarker) {
        if (this.markerToEntryMap == null) {
            this.markerToEntryMap = new HashMap();
            int n = 0;
            while (n < this.markers.length) {
                IMarker iMarker2 = this.markers[n].getMarker();
                if (iMarker2 != null) {
                    this.markerToEntryMap.put(iMarker2, this.markers[n]);
                }
                ++n;
            }
        }
        if (this.markerToEntryMap.containsKey(iMarker)) {
            return (MarkerItem)this.markerToEntryMap.get(iMarker);
        }
        return null;
    }

    public int getSize() {
        return this.markers.length;
    }

    public MarkerEntry[] toArray() {
        return this.markers;
    }

    void clearAttributeCaches() {
        int n = 0;
        while (n < this.markers.length) {
            this.markers[n].clearCaches();
            ++n;
        }
    }
}

