/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerPreferencesDialog
extends ViewSettingsDialog {
    private IntegerFieldEditor limitEditor;
    private Button enablementButton;
    private Composite editArea;
    private Label messageLabel;
    private ExtendedMarkersView extendedView;
    private ArrayList visible;
    private ArrayList hidden;
    private ListViewer visibleViewer;
    private ListViewer nonVisibleViewer;

    public MarkerPreferencesDialog(ExtendedMarkersView extendedMarkersView) {
        super(extendedMarkersView.getSite().getShell());
        this.extendedView = extendedMarkersView;
        MarkerField[] markerFieldArray = extendedMarkersView.getVisibleFields();
        Object[] objectArray = extendedMarkersView.getHiddenFields();
        this.visible = new ArrayList();
        this.hidden = new ArrayList();
        int n = 0;
        while (n < markerFieldArray.length) {
            this.visible.add(markerFieldArray[n]);
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            this.hidden.add(objectArray[n]);
            ++n;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MarkerMessages.MarkerPreferences_DialogTitle);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        boolean bl = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("USE_MARKER_LIMITS");
        this.enablementButton = new Button(composite2, 32);
        this.enablementButton.setText(MarkerMessages.MarkerPreferences_MarkerLimits);
        this.enablementButton.setSelection(bl);
        this.editArea = new Composite(composite2, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        this.editArea.setLayoutData((Object)gridData);
        this.limitEditor = new IntegerFieldEditor("limit", MarkerMessages.MarkerPreferences_VisibleItems, this.editArea){

            protected boolean checkState() {
                boolean bl = super.checkState();
                MarkerPreferencesDialog.this.setValid(bl, this.getErrorMessage());
                return bl;
            }
        };
        this.limitEditor.setPreferenceStore(IDEWorkbenchPlugin.getDefault().getPreferenceStore());
        this.limitEditor.setPreferenceName("MARKER_LIMITS_VALUE");
        this.limitEditor.load();
        GridData gridData2 = new GridData(4, 0, true, false);
        gridData2.horizontalSpan = this.limitEditor.getNumberOfControls();
        this.enablementButton.setLayoutData((Object)gridData2);
        this.enablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerPreferencesDialog.this.setLimitEditorEnablement(MarkerPreferencesDialog.this.editArea, MarkerPreferencesDialog.this.enablementButton.getSelection());
            }
        });
        this.setLimitEditorEnablement(this.editArea, bl);
        this.messageLabel = new Label(composite2, 0);
        this.messageLabel.setBackground(JFaceColors.getErrorBackground((Display)composite2.getDisplay()));
        this.messageLabel.setForeground(JFaceColors.getErrorText((Display)composite2.getDisplay()));
        this.messageLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createColumnsArea(composite2);
        MarkerPreferencesDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createColumnsArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Group group = new Group(composite, 0);
        group.setText(MarkerMessages.MarkerPreferences_ColumnGroupTitle);
        FormLayout formLayout = new FormLayout();
        group.setLayout((Layout)formLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label((Composite)group, 0);
        label.setText(MarkerMessages.MarkerPreferences_VisibleColumnsTitle);
        FormData formData = new FormData();
        formData.right = new FormAttachment(45, 0);
        formData.left = new FormAttachment(4);
        formData.top = new FormAttachment(0);
        label.setLayoutData((Object)formData);
        int n = -4;
        Label label2 = new Label((Composite)group, 0);
        label2.setText(MarkerMessages.MarkerPreferences_HiddenColumnsTitle);
        FormData formData2 = new FormData();
        formData2.right = new FormAttachment(100);
        formData2.left = new FormAttachment(55, 0);
        formData2.top = new FormAttachment(0);
        label2.setLayoutData((Object)formData2);
        this.visibleViewer = new ListViewer((Composite)group, 2048);
        FormData formData3 = new FormData();
        formData3.right = new FormAttachment((Control)label, 0, 131072);
        formData3.left = new FormAttachment((Control)label, 0, 16384);
        formData3.top = new FormAttachment((Control)label, 4);
        formData3.bottom = new FormAttachment(100, n);
        formData3.height = this.convertHeightInCharsToPixels(15);
        formData3.width = this.convertWidthInCharsToPixels(25);
        this.visibleViewer.getControl().setLayoutData((Object)formData3);
        this.visibleViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return MarkerPreferencesDialog.this.visible.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.visibleViewer.setLabelProvider((IBaseLabelProvider)this.markerFieldLabelProvider());
        this.visibleViewer.setInput((Object)this);
        this.nonVisibleViewer = new ListViewer((Composite)group, 2048);
        this.nonVisibleViewer.setLabelProvider((IBaseLabelProvider)this.markerFieldLabelProvider());
        this.nonVisibleViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return MarkerPreferencesDialog.this.hidden.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.nonVisibleViewer.setInput((Object)this);
        FormData formData4 = new FormData();
        formData4.right = new FormAttachment((Control)label2, 0, 131072);
        formData4.left = new FormAttachment((Control)label2, 0, 16384);
        formData4.top = new FormAttachment((Control)label2, 4);
        formData4.bottom = new FormAttachment(100, n);
        formData4.height = this.convertHeightInCharsToPixels(15);
        formData4.width = this.convertWidthInCharsToPixels(25);
        this.nonVisibleViewer.getControl().setLayoutData((Object)formData4);
        Button button = new Button((Composite)group, 8);
        button.setText(MarkerPreferencesDialog.getDefaultOrientation() == 0x4000000 ? MarkerMessages.MarkerPreferences_MoveLeft : MarkerMessages.MarkerPreferences_MoveRight);
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment(this.visibleViewer.getControl(), 25, 128);
        formData5.left = new FormAttachment(this.visibleViewer.getControl(), 4);
        formData5.right = new FormAttachment(this.nonVisibleViewer.getControl(), n);
        button.setLayoutData((Object)formData5);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list = ((IStructuredSelection)MarkerPreferencesDialog.this.visibleViewer.getSelection()).toList();
                MarkerPreferencesDialog.this.hidden.addAll(list);
                MarkerPreferencesDialog.this.visible.removeAll(list);
                MarkerPreferencesDialog.this.visibleViewer.refresh();
                MarkerPreferencesDialog.this.nonVisibleViewer.refresh();
            }
        });
        Button button2 = new Button((Composite)group, 8);
        button2.setText(MarkerPreferencesDialog.getDefaultOrientation() == 0x4000000 ? MarkerMessages.MarkerPreferences_MoveRight : MarkerMessages.MarkerPreferences_MoveLeft);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)button, 4);
        formData6.left = new FormAttachment(this.visibleViewer.getControl(), 4);
        formData6.right = new FormAttachment(this.nonVisibleViewer.getControl(), n);
        button2.setLayoutData((Object)formData6);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list = ((IStructuredSelection)MarkerPreferencesDialog.this.nonVisibleViewer.getSelection()).toList();
                MarkerPreferencesDialog.this.hidden.removeAll(list);
                MarkerPreferencesDialog.this.visible.addAll(list);
                MarkerPreferencesDialog.this.visibleViewer.refresh();
                MarkerPreferencesDialog.this.nonVisibleViewer.refresh();
            }
        });
    }

    private LabelProvider markerFieldLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                return ((MarkerField)object).getColumnHeaderText();
            }
        };
    }

    protected void setValid(boolean bl, String string) {
        Button button = this.getButton(0);
        if (button == null) {
            return;
        }
        if (bl) {
            this.messageLabel.setText("");
        } else {
            this.messageLabel.setText(string);
        }
        button.setEnabled(bl);
    }

    private void setLimitEditorEnablement(Composite composite, boolean bl) {
        this.limitEditor.setEnabled(bl, composite);
    }

    protected void okPressed() {
        this.limitEditor.store();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("USE_MARKER_LIMITS", this.enablementButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        this.extendedView.setVisibleFields(this.visible);
        super.okPressed();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.limitEditor.loadDefault();
        boolean bl = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getDefaultBoolean("USE_MARKER_LIMITS");
        this.enablementButton.setSelection(bl);
        this.setLimitEditorEnablement(this.editArea, bl);
        MarkerField[] markerFieldArray = this.extendedView.getBuilder().getGenerator().getInitialVisible();
        MarkerField[] markerFieldArray2 = this.extendedView.getBuilder().getGenerator().getAllFields();
        this.visible.clear();
        this.hidden.clear();
        int n = 0;
        while (n < markerFieldArray2.length) {
            this.hidden.add(markerFieldArray2[n]);
            ++n;
        }
        n = 0;
        while (n < markerFieldArray.length) {
            this.hidden.remove(markerFieldArray[n]);
            this.visible.add(markerFieldArray[n]);
            ++n;
        }
        this.visibleViewer.refresh();
        this.nonVisibleViewer.refresh();
    }
}

