/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerPriorityField
extends MarkerField {
    static final String HIGH_PRIORITY_IMAGE_PATH = "$nl$/icons/full/obj16/hprio_tsk.gif";
    static final String LOW_PRIORITY_IMAGE_PATH = "$nl$/icons/full/obj16/lprio_tsk.gif";
    private static String[] priorities = new String[]{MarkerMessages.priority_low, MarkerMessages.priority_normal, MarkerMessages.priority_high};

    public int compare(MarkerItem markerItem, MarkerItem markerItem2) {
        return markerItem2.getAttributeValue("priority", 1) - markerItem.getAttributeValue("priority", 1);
    }

    public String getColumnHeaderText() {
        return "";
    }

    public String getColumnTooltipText() {
        return MarkerMessages.priority_description;
    }

    public int getDefaultColumnWidth(Control control) {
        return this.getHighPriorityImage().getBounds().width;
    }

    public EditingSupport getEditingSupport(ColumnViewer columnViewer) {
        return new PriorityEditingSupport(columnViewer);
    }

    private Image getHighPriorityImage() {
        return MarkerSupportInternalUtilities.createImage(HIGH_PRIORITY_IMAGE_PATH, this.getImageManager());
    }

    public String getValue(MarkerItem markerItem) {
        return "";
    }

    public void update(ViewerCell viewerCell) {
        super.update(viewerCell);
        try {
            switch (((MarkerItem)viewerCell.getElement()).getAttributeValue("priority", 1)) {
                case 2: {
                    viewerCell.setImage(this.getHighPriorityImage());
                    break;
                }
                case 1: {
                    viewerCell.setImage(null);
                    break;
                }
                case 0: {
                    viewerCell.setImage(MarkerSupportInternalUtilities.createImage(LOW_PRIORITY_IMAGE_PATH, this.getImageManager()));
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private class PriorityEditingSupport
    extends EditingSupport {
        private ComboBoxCellEditor editor;

        public PriorityEditingSupport(ColumnViewer columnViewer) {
            super(columnViewer);
            this.editor = new ComboBoxCellEditor((Composite)columnViewer.getControl(), priorities, 8);
        }

        protected boolean canEdit(Object object) {
            if (object instanceof MarkerEntry) {
                return ((MarkerEntry)object).getAttributeValue("userEditable", false);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            return new Integer(((MarkerEntry)object).getAttributeValue("priority", 1));
        }

        protected void setValue(Object object, Object object2) {
            MarkerEntry markerEntry = (MarkerEntry)object;
            Integer n = (Integer)object2;
            try {
                markerEntry.getMarker().setAttribute("priority", n.intValue());
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
            }
        }
    }
}

