/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.actions.SimpleWildcardTester;

public class MarkerPropertyTester
extends PropertyTester {
    public static final String PRIORITY = "priority";
    public static final String SEVERITY = "severity";
    public static final String DONE = "done";
    public static final String MESSAGE = "message";
    public static final String TYPE = "type";
    public static final String SUPER_TYPE = "superType";
    public static final String RESOURCE_TYPE = "resourceType";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        return MarkerPropertyTester.test((IMarker)object, string, object2.toString());
    }

    private static boolean testIntegerAttribute(IMarker iMarker, String string, String string2) {
        Integer n;
        Integer n2;
        try {
            n2 = (Integer)iMarker.getAttribute(string);
            if (n2 == null) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n2.equals(n);
    }

    public static boolean test(IMarker iMarker, String string, String string2) {
        if (TYPE.equals(string)) {
            try {
                return string2.equals(iMarker.getType());
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (SUPER_TYPE.equals(string)) {
            try {
                return iMarker.isSubtypeOf(string2);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (PRIORITY.equals(string)) {
            return MarkerPropertyTester.testIntegerAttribute(iMarker, PRIORITY, string2);
        }
        if (SEVERITY.equals(string)) {
            return MarkerPropertyTester.testIntegerAttribute(iMarker, SEVERITY, string2);
        }
        if (MESSAGE.equals(string)) {
            String string3;
            block20: {
                try {
                    string3 = (String)iMarker.getAttribute(MESSAGE);
                    if (string3 != null) break block20;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return SimpleWildcardTester.testWildcardIgnoreCase((String)string2, (String)string3);
        }
        if (DONE.equals(string)) {
            Boolean bl;
            block21: {
                try {
                    string2 = string2.toLowerCase();
                    bl = (Boolean)iMarker.getAttribute(DONE);
                    if (bl != null) break block21;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return bl.booleanValue() == string2.equals("true");
        }
        if (RESOURCE_TYPE.equals(string)) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
            if (n != 1 && n != 2 && n != 4 && n != 8) {
                return false;
            }
            return (iMarker.getResource().getType() & n) > 0;
        }
        return false;
    }
}

