/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;

public class MarkerSupportInternalUtilities {
    static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_FILTER_CLASS = "filterClass";
    private static final String ATTRIBUTE_FILTER_CONFIGURATION_CLASS = "filterConfigurationClass";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    static final Object CONTAINS_MODIFIER_TOKEN = new Object();
    static final Object CONTAINS_TEXT_TOKEN = new Object();
    static final CollationKey EMPTY_COLLATION_KEY = Collator.getInstance().getCollationKey("");
    static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];
    static final MarkerSupportItem[] EMPTY_MARKER_ITEM_ARRAY = new MarkerSupportItem[0];
    static final IResource[] EMPTY_RESOURCE_ARRAY = new IResource[0];
    public static final String EMPTY_STRING = "";
    static final String FALSE = "false";
    public static final String IMG_MARKERS_HELP_DECORATION_PATH = "markers/help_small.gif";
    public static final String IMG_MARKERS_QUICK_FIX_DECORATION_PATH = "markers/contassist_ovr.gif";
    public static final String LEGACY_SUFFIX = ".old";
    public static final String MIGRATE_PREFERENCE_CONSTANT = "_MIGRATE";
    public static final String MIGRATE_BOOKMARK_FILTERS = "BOOKMARKS_FILTERS_MIGRATE";
    public static final String MIGRATE_PROBLEM_FILTERS = "PROBLEMS_FILTERS_MIGRATE";
    public static final String MIGRATE_TASK_FILTERS = "TASKS_FILTERS_MIGRATE";
    public static final Object VALUE_FALSE = "false";

    static final Image createImage(String string, ResourceManager resourceManager) {
        URL uRL = BundleUtility.find((String)IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), (String)string);
        if (uRL == null) {
            return null;
        }
        return resourceManager.createImageWithDefault(ImageDescriptor.createFromURL((URL)uRL));
    }

    static final StatusAdapter errorFor(Throwable throwable) {
        Status status = new Status(4, "org.eclipse.ui.ide", 4, throwable.getLocalizedMessage(), throwable);
        return new StatusAdapter((IStatus)status);
    }

    static final MarkerFieldFilter generateFilter(MarkerField markerField) {
        Object object;
        block5: {
            IConfigurationElement iConfigurationElement;
            block4: {
                iConfigurationElement = markerField.getConfigurationElement();
                try {
                    if (iConfigurationElement.getAttribute(ATTRIBUTE_FILTER_CLASS) != null) break block4;
                    return null;
                }
                catch (CoreException coreException) {
                    Policy.handle(coreException);
                    return null;
                }
            }
            object = IDEWorkbenchPlugin.createExtension(iConfigurationElement, ATTRIBUTE_FILTER_CLASS);
            if (object != null) break block5;
            return null;
        }
        MarkerFieldFilter markerFieldFilter = (MarkerFieldFilter)object;
        markerFieldFilter.setField(markerField);
        return markerFieldFilter;
    }

    static final FilterConfigurationArea generateFilterArea(MarkerField markerField) {
        IConfigurationElement iConfigurationElement;
        block4: {
            iConfigurationElement = markerField.getConfigurationElement();
            try {
                if (iConfigurationElement.getAttribute(ATTRIBUTE_FILTER_CONFIGURATION_CLASS) != null) break block4;
                return null;
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
                return null;
            }
        }
        FilterConfigurationArea filterConfigurationArea = (FilterConfigurationArea)IDEWorkbenchPlugin.createExtension(iConfigurationElement, ATTRIBUTE_FILTER_CONFIGURATION_CLASS);
        if (filterConfigurationArea != null) {
            filterConfigurationArea.setField(markerField);
        }
        return filterConfigurationArea;
    }

    public static final MarkerItem[] getChildren(MarkerItem markerItem) {
        if (markerItem instanceof MarkerCategory) {
            return ((MarkerCategory)markerItem).getChildren();
        }
        return EMPTY_MARKER_ITEM_ARRAY;
    }

    public static final int getFontWidth(Control control) {
        GC gC = new GC((Drawable)control.getDisplay());
        int n = gC.getFontMetrics().getAverageCharWidth();
        gC.dispose();
        return n;
    }

    public static final String getGroupValue(MarkerGroup markerGroup, MarkerItem markerItem) {
        if (markerItem.getMarker() == null) {
            return ((MarkerSupportItem)markerItem).getDescription();
        }
        try {
            MarkerGroupingEntry markerGroupingEntry = markerGroup.findGroupValue(markerItem.getMarker().getType(), markerItem.getMarker());
            return markerGroupingEntry.getLabel();
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return EMPTY_STRING;
        }
    }

    public static final int getHighestSeverity(MarkerItem markerItem) {
        if (markerItem instanceof MarkerCategory) {
            MarkerCategory markerCategory = (MarkerCategory)markerItem;
            return markerCategory.getHighestSeverity();
        }
        IMarker iMarker = markerItem.getMarker();
        Assert.isNotNull((Object)iMarker);
        return iMarker.getAttribute("severity", 0);
    }

    public static final String getId(MarkerField markerField) {
        return markerField.getConfigurationElement().getAttribute(ATTRIBUTE_ID);
    }

    private static Image getIDEImage(String string) {
        return JFaceResources.getResources().createImageWithDefault(IDEInternalWorkbenchImages.getImageDescriptor(string));
    }

    static int getMarkerLimit() {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("USE_MARKER_LIMITS")) {
            return IDEWorkbenchPlugin.getDefault().getPreferenceStore().getInt("MARKER_LIMITS_VALUE");
        }
        return -1;
    }

    static int getSeverity(MarkerItem markerItem) {
        return markerItem.getAttributeValue("severity", -1);
    }

    public static Image getSeverityImage(int n) {
        if (n == 2) {
            return MarkerSupportInternalUtilities.getIDEImage("IMG_OBJS_ERROR_PATH");
        }
        if (n == 1) {
            return MarkerSupportInternalUtilities.getIDEImage("IMG_OBJS_WARNING_PATH");
        }
        if (n == 0) {
            return MarkerSupportInternalUtilities.getIDEImage("IMG_OBJS_INFO_PATH");
        }
        return null;
    }

    static MarkerItem newMarkerItem(IMarker iMarker) {
        return new MarkerEntry(iMarker);
    }

    public static boolean showMarker(IViewPart iViewPart, IMarker iMarker) {
        if (iViewPart instanceof ExtendedMarkersView) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)iMarker);
            ExtendedMarkersView extendedMarkersView = (ExtendedMarkersView)iViewPart;
            extendedMarkersView.setSelection(structuredSelection, true);
            return true;
        }
        return false;
    }
}

