/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class MarkerTypeFieldFilter
extends CompatibilityFieldFilter {
    private static final String TAG_TYPES_DELIMITER = ":";
    private static final String TAG_SELECTED_TYPES = "selectedTypes";
    Collection selectedTypes = new HashSet();
    private MarkerContentGenerator contentGenerator;

    public boolean select(MarkerItem markerItem) {
        IMarker iMarker = markerItem.getMarker();
        if (iMarker == null) {
            return this.contentGenerator.allTypesSelected(this.selectedTypes);
        }
        try {
            return this.selectedTypes.contains(MarkerTypesModel.getInstance().getType(iMarker.getType()));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    void setSelectedTypes(Collection collection, MarkerContentGenerator markerContentGenerator) {
        this.setContentGenerator(markerContentGenerator);
        this.selectedTypes = collection;
    }

    Collection getSelectedTypes() {
        return this.selectedTypes;
    }

    public void saveSettings(IMemento iMemento) {
        if (this.selectedTypes.containsAll(this.contentGenerator.getMarkerTypes())) {
            return;
        }
        Iterator iterator = this.selectedTypes.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            MarkerType markerType = (MarkerType)iterator.next();
            stringBuffer.append(markerType.getId());
            stringBuffer.append(TAG_TYPES_DELIMITER);
        }
        iMemento.putString(TAG_SELECTED_TYPES, stringBuffer.toString());
    }

    public void loadSettings(IMemento iMemento) {
        String string = iMemento.getString(TAG_SELECTED_TYPES);
        if (string == null) {
            return;
        }
        this.selectedTypes.clear();
        int n = 0;
        int n2 = string.indexOf(TAG_TYPES_DELIMITER, 0);
        while (n2 > 0) {
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(TAG_TYPES_DELIMITER, n);
            MarkerType markerType = this.contentGenerator.getType(string2);
            if (markerType == null) continue;
            this.selectedTypes.add(markerType);
        }
    }

    void loadLegacySettings(IMemento iMemento, MarkerContentGenerator markerContentGenerator) {
        this.setContentGenerator(markerContentGenerator);
        String string = iMemento.getString("selectionStatus");
        if (string != null) {
            this.selectedTypes.clear();
            ArrayList arrayList = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String string2 = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String string3 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = this.contentGenerator.getType(string2)) == null) continue;
                arrayList.remove(markerType);
                if ("false".equals(string3) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
        }
    }

    public void initialize(ProblemFilter problemFilter) {
        this.selectedTypes.clear();
        this.selectedTypes.addAll(problemFilter.getSelectedTypes());
    }

    void setContentGenerator(MarkerContentGenerator markerContentGenerator) {
        this.contentGenerator = markerContentGenerator;
        this.selectedTypes = new HashSet();
        this.selectedTypes.addAll(markerContentGenerator.getMarkerTypes());
    }

    public void populateWorkingCopy(MarkerFieldFilter markerFieldFilter) {
        super.populateWorkingCopy(markerFieldFilter);
        ((MarkerTypeFieldFilter)markerFieldFilter).selectedTypes = new HashSet(this.selectedTypes);
        ((MarkerTypeFieldFilter)markerFieldFilter).contentGenerator = this.contentGenerator;
    }
}

