/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkersPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text descriptionText;
    private IMarker marker;
    Combo priorityCombo;
    Button completedCheckbox;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite composite) {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = iAdaptable.getAdapter((Class)clazz);
        IWorkspaceRoot iWorkspaceRoot = null;
        if (object != null) {
            this.marker = (IMarker)object;
            iWorkspaceRoot = this.marker.getResource();
        } else if (iWorkspaceRoot == null) {
            iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        if (!Util.isEditable(this.marker)) {
            this.noDefaultAndApplyButton();
        }
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite2);
        this.createDescriptionArea(composite2);
        if (object != null) {
            this.createSeperator(composite2);
            this.createCreationTimeArea(composite2);
        }
        this.createAttributesArea(composite2);
        if (iWorkspaceRoot != null) {
            this.createSeperator(composite2);
            this.createResourceArea(composite2);
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void createSeperator(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createCreationTimeArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_creationTime_text);
        Label label2 = new Label(composite, 0);
        label2.setText(Util.getCreationTime(this.marker));
    }

    private void createDescriptionArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_description_text);
        this.descriptionText = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setText(Util.getProperty("message", this.marker));
        this.descriptionText.selectAll();
        this.descriptionText.setEditable(Util.isEditable(this.marker));
    }

    protected void createAttributesArea(Composite composite) {
        try {
            if (this.marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                this.createProblemAttributes(composite);
            }
            if (this.marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                this.createTaskAttributes(composite);
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
    }

    private void createTaskAttributes(Composite composite) {
        this.createSeperator(composite);
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_priority);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.priorityCombo = new Combo(composite2, 8);
        this.priorityCombo.setItems(new String[]{MarkerMessages.propertiesDialog_priorityLow, MarkerMessages.propertiesDialog_priorityNormal, MarkerMessages.propertiesDialog_priorityHigh});
        this.priorityCombo.select(this.marker.getAttribute("priority", 1));
        this.priorityCombo.setEnabled(Util.isEditable(this.marker));
        this.completedCheckbox = new Button(composite2, 32);
        this.completedCheckbox.setText(MarkerMessages.propertiesDialog_completed);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.setEnabled(Util.isEditable(this.marker));
        try {
            Object object = this.marker.getAttribute("done");
            this.completedCheckbox.setSelection(object != null && object instanceof Boolean && (Boolean)object != false);
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
    }

    private void createProblemAttributes(Composite composite) {
        this.createSeperator(composite);
        new Label(composite, 0).setText(MarkerMessages.propertiesDialog_severityLabel);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setImage(Util.getImage(this.marker.getAttribute("severity", -1)));
        Label label2 = new Label(composite2, 0);
        int n = this.marker.getAttribute("severity", -1);
        if (n == 2) {
            label2.setText(MarkerMessages.propertiesDialog_errorLabel);
        } else if (n == 1) {
            label2.setText(MarkerMessages.propertiesDialog_warningLabel);
        } else if (n == 0) {
            label2.setText(MarkerMessages.propertiesDialog_infoLabel);
        } else {
            label2.setText(MarkerMessages.propertiesDialog_noseverityLabel);
        }
    }

    private void createResourceArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_resource_text);
        Text text = new Text(composite, 2124);
        GridData gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        text.setText(Util.getResourceName(this.marker));
        Label label2 = new Label(composite, 0);
        label2.setText(MarkerMessages.propertiesDialog_folder_text);
        Text text2 = new Text(composite, 2124);
        gridData = new GridData(768);
        text2.setLayoutData((Object)gridData);
        text2.setText(Util.getContainerName(this.marker));
        Label label3 = new Label(composite, 0);
        label3.setText(MarkerMessages.propertiesDialog_location_text);
        Text text3 = new Text(composite, 2124);
        gridData = new GridData(768);
        text3.setLayoutData((Object)gridData);
        String string = Util.getProperty("lineNumber", this.marker);
        if (string.length() == 0) {
            text3.setText("");
        } else {
            text3.setText(NLS.bind((String)MarkerMessages.label_lineNumber, (Object)string));
        }
    }

    public boolean performOk() {
        if (this.marker == null || Util.isEditable(this.marker)) {
            this.saveChanges();
        }
        return super.performOk();
    }

    private void saveChanges() {
        HashMap<String, String> hashMap;
        try {
            hashMap = this.marker.getAttributes();
        }
        catch (CoreException coreException) {
            hashMap = new HashMap<String, String>();
            Policy.handle(coreException);
        }
        hashMap.put("message", this.descriptionText.getText());
        if (this.priorityCombo != null) {
            int n = 1;
            int n2 = this.priorityCombo.getSelectionIndex();
            if (n2 == this.priorityCombo.indexOf(MarkerMessages.propertiesDialog_priorityHigh)) {
                n = 2;
            } else if (n2 == this.priorityCombo.indexOf(MarkerMessages.propertiesDialog_priorityLow)) {
                n = 0;
            }
            hashMap.put("priority", (String)((Object)new Integer(n)));
        }
        if (this.completedCheckbox != null) {
            hashMap.put("done", (String)((Object)(this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE)));
        }
        UpdateMarkersOperation updateMarkersOperation = new UpdateMarkersOperation(this.marker, hashMap, NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object[])new Object[]{MarkerMessages.DialogMarkerProperties_Modify, Util.getResourceName(this.marker)}), true);
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)updateMarkersOperation, (IProgressMonitor)new NullProgressMonitor(), WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)executionException.getCause()).getStatus(), 2);
            }
            StatusManager.getManager().handle(StatusUtil.newStatus(4, executionException.getLocalizedMessage(), (Throwable)executionException));
        }
    }
}

