/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class PriorityMarkerFieldFilter
extends CompatibilityFieldFilter {
    static final int PRIORITY_HIGH = 4;
    static final int PRIORITY_NORMAL = 2;
    static final int PRIORITY_LOW = 1;
    private static final String TAG_SELECTED_PRIORITIES = "selectedPriorities";
    int selectedPriorities = 7;

    public void loadSettings(IMemento iMemento) {
        Integer n = iMemento.getInteger(TAG_SELECTED_PRIORITIES);
        if (n == null) {
            return;
        }
        this.selectedPriorities = n;
    }

    void loadLegacySettings(IMemento iMemento, MarkerContentGenerator markerContentGenerator) {
        String string = iMemento.getString("priority");
        if (string != null) {
            try {
                this.selectedPriorities = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void initialize(ProblemFilter problemFilter) {
    }

    public void saveSettings(IMemento iMemento) {
        iMemento.putInteger(TAG_SELECTED_PRIORITIES, this.selectedPriorities);
    }

    public boolean select(MarkerItem markerItem) {
        if (this.selectedPriorities == 0) {
            return true;
        }
        IMarker iMarker = markerItem.getMarker();
        if (iMarker == null) {
            return false;
        }
        int n = 1 << iMarker.getAttribute("priority", 1);
        switch (n) {
            case 4: {
                return (this.selectedPriorities & 4) > 0;
            }
            case 2: {
                return (this.selectedPriorities & 2) > 0;
            }
            case 1: {
                return (this.selectedPriorities & 1) > 0;
            }
        }
        return true;
    }

    public void populateWorkingCopy(MarkerFieldFilter markerFieldFilter) {
        super.populateWorkingCopy(markerFieldFilter);
        ((PriorityMarkerFieldFilter)markerFieldFilter).selectedPriorities = this.selectedPriorities;
    }
}

