/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.SeverityAndDescriptionFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class ProblemsSeverityAndDescriptionFieldFilter
extends SeverityAndDescriptionFieldFilter {
    public boolean select(MarkerItem markerItem) {
        IMarker iMarker = markerItem.getMarker();
        if (iMarker == null) {
            return false;
        }
        int n = markerItem.getAttributeValue("severity", -1);
        if (n < 0) {
            return false;
        }
        if (this.checkSeverity(n)) {
            return super.select(markerItem);
        }
        return false;
    }

    void loadLegacySettings(IMemento iMemento, MarkerContentGenerator markerContentGenerator) {
        super.loadLegacySettings(iMemento, markerContentGenerator);
        Integer n = iMemento.getInteger("severity");
        if (n != null) {
            this.selectedSeverities = n;
        }
    }

    public void initialize(ProblemFilter problemFilter) {
        super.initialize(problemFilter);
        if (problemFilter.getSeverity() > 0) {
            this.selectedSeverities = problemFilter.getSeverity();
        }
    }
}

