/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.markers.QuickFixWizard;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class QuickFixHandler
extends MarkerViewHandler {
    static /* synthetic */ Class class$0;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final MarkerSupportView markerSupportView = this.getView(executionEvent);
        if (markerSupportView == null) {
            return this;
        }
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        final IMarker iMarker = markerSupportView.getSelectedMarkers()[0];
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(MarkerMessages.resolveMarkerAction_computationManyAction, 100);
                IMarker[] iMarkerArray = markerSupportView.getAllMarkers();
                iProgressMonitor.worked(20);
                IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(iMarker);
                int n = 80;
                if (iMarkerResolutionArray.length > 1) {
                    n /= iMarkerResolutionArray.length;
                }
                int n2 = 0;
                while (n2 < iMarkerResolutionArray.length) {
                    IMarker[] iMarkerArray2;
                    IMarkerResolution iMarkerResolution = iMarkerResolutionArray[n2];
                    if (iMarkerResolution instanceof WorkbenchMarkerResolution) {
                        iMarkerArray2 = ((WorkbenchMarkerResolution)iMarkerResolution).findOtherMarkers(iMarkerArray);
                        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
                        arrayList.add(iMarker);
                        int n3 = 0;
                        while (n3 < iMarkerArray2.length) {
                            arrayList.add(iMarkerArray2[n3]);
                            ++n3;
                        }
                        linkedHashMap.put(iMarkerResolution, arrayList);
                    } else {
                        iMarkerArray2 = new ArrayList();
                        iMarkerArray2.add(iMarker);
                        linkedHashMap.put(iMarkerResolution, iMarkerArray2);
                    }
                    iProgressMonitor.worked(n);
                    ++n2;
                }
                iProgressMonitor.done();
            }
        };
        IWorkbenchPartSite iWorkbenchPartSite = markerSupportView.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = iWorkbenchPartSite.getAdapter((Class)clazz);
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(markerSupportView.getSite().getShell());
        try {
            if (object == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, null);
            } else {
                ((IWorkbenchSiteProgressService)object).runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, null);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ExecutionException(invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            throw new ExecutionException(interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
        }
        String string = iMarker.getAttribute("message", "");
        if (linkedHashMap.isEmpty()) {
            Status status = new Status(1, "org.eclipse.ui.ide", NLS.bind((String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFound, (Object[])new Object[]{string}));
            StatusAdapter statusAdapter = new StatusAdapter((IStatus)status);
            statusAdapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)MarkerMessages.MarkerResolutionDialog_CannotFixTitle);
            StatusManager.getManager().handle(statusAdapter, 2);
        } else {
            String string2 = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)string);
            QuickFixWizard quickFixWizard = new QuickFixWizard(string2, linkedHashMap, markerSupportView.getSite());
            quickFixWizard.setWindowTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
            QuickFixWizardDialog quickFixWizardDialog = new QuickFixWizardDialog(markerSupportView.getSite().getShell(), (IWizard)quickFixWizard);
            quickFixWizardDialog.open();
        }
        return this;
    }

    private class QuickFixWizardDialog
    extends WizardDialog {
        public QuickFixWizardDialog(Shell shell, IWizard iWizard) {
            super(shell, iWizard);
            this.setShellStyle(0xC70 | QuickFixWizardDialog.getDefaultOrientation());
        }
    }
}

