/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class QuickFixPage
extends WizardPage {
    private Map resolutions;
    private ListViewer resolutionsList;
    private CheckboxTableViewer markersTable;
    private IWorkbenchPartSite site;

    public QuickFixPage(String string, Map map, IWorkbenchPartSite iWorkbenchPartSite) {
        super(string);
        this.resolutions = map;
        this.site = iWorkbenchPartSite;
        this.setTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
        this.setMessage(string);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.problem_view_context");
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        formLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        formLayout.spacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)formLayout);
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.MarkerResolutionDialog_Resolutions_List_Title);
        label.setLayoutData((Object)new FormData());
        this.createResolutionsList(composite2);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)label, 0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.convertHeightInCharsToPixels(10);
        this.resolutionsList.getControl().setLayoutData((Object)formData);
        Label label2 = new Label(composite2, 0);
        label2.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Title);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(this.resolutionsList.getControl(), 0);
        formData2.left = new FormAttachment(0);
        label2.setLayoutData((Object)formData2);
        this.createMarkerTable(composite2);
        Composite composite3 = this.createTableButtons(composite2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)label2, 0);
        formData3.right = new FormAttachment(100);
        formData3.height = this.convertHeightInCharsToPixels(10);
        composite3.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)composite3, 0, 128);
        formData4.left = new FormAttachment(0);
        formData4.bottom = new FormAttachment(100);
        formData4.right = new FormAttachment((Control)composite3, 0);
        formData4.height = this.convertHeightInCharsToPixels(10);
        this.markersTable.getControl().setLayoutData((Object)formData4);
        Dialog.applyDialogFont((Control)composite2);
        this.resolutionsList.setSelection((ISelection)new StructuredSelection(this.resolutionsList.getElementAt(0)));
        this.markersTable.setAllChecked(true);
    }

    private Composite createTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Button button = new Button(composite2, 8);
        button.setText(MarkerMessages.selectAllAction_title);
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                QuickFixPage.this.markersTable.setAllChecked(true);
                QuickFixPage.this.setPageComplete(!QuickFixPage.this.resolutionsList.getSelection().isEmpty());
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(MarkerMessages.filtersDialog_deselectAll);
        button2.setLayoutData((Object)new GridData(4, 0, false, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                QuickFixPage.this.markersTable.setAllChecked(false);
                QuickFixPage.this.setPageComplete(false);
            }
        });
        return composite2;
    }

    private void createResolutionsList(Composite composite) {
        this.resolutionsList = new ListViewer(composite, 2564);
        this.resolutionsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return QuickFixPage.this.resolutions.keySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((IMarkerResolution)object).getLabel();
            }
        });
        this.resolutionsList.setInput((Object)this);
        this.resolutionsList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return ((IMarkerResolution)object).getLabel().compareTo(((IMarkerResolution)object).getLabel());
            }
        });
        this.resolutionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                QuickFixPage.this.markersTable.refresh();
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage == null) {
                    return;
                }
            }
        });
    }

    private void createMarkerTable(Composite composite) {
        this.markersTable = CheckboxTableViewer.newCheckList((Composite)composite, (int)2564);
        this.createTableColumns();
        this.markersTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                IMarkerResolution iMarkerResolution = QuickFixPage.this.getSelectedResolution();
                if (iMarkerResolution == null) {
                    return new Object[0];
                }
                if (QuickFixPage.this.resolutions.containsKey(iMarkerResolution)) {
                    return ((Collection)QuickFixPage.this.resolutions.get(iMarkerResolution)).toArray();
                }
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.markersTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                if (n == 0) {
                    return Util.getImage(((IMarker)object).getAttribute("severity", -1));
                }
                return null;
            }

            public String getColumnText(Object object, int n) {
                IMarker iMarker = (IMarker)object;
                if (n == 0) {
                    return Util.getResourceName(iMarker);
                }
                String string = iMarker.getAttribute("location", "");
                if (string.length() > 0) {
                    return string;
                }
                int n2 = iMarker.getAttribute("lineNumber", -1);
                String string2 = null;
                string2 = n2 < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(n2));
                return string2;
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        this.markersTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getChecked()) {
                    QuickFixPage.this.setPageComplete(true);
                } else {
                    QuickFixPage.this.setPageComplete(QuickFixPage.this.markersTable.getCheckedElements().length > 0);
                }
            }
        });
        this.markersTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection().isEmpty()) {
                    return;
                }
                IMarker iMarker = (IMarker)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                ExtendedMarkersView.openMarkerInEditor(iMarker, QuickFixPage.this.site.getPage());
            }
        });
        this.markersTable.setInput((Object)this);
    }

    private void createTableColumns() {
        TableLayout tableLayout = new TableLayout();
        Table table = this.markersTable.getTable();
        table.setLayout((Layout)tableLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        TableColumn tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Location);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Resource);
    }

    public IMarker getSelectedMarker() {
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = this.markersTable.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            return (IMarker)iStructuredSelection.getFirstElement();
        }
        return null;
    }

    public boolean isPageComplete() {
        return true;
    }

    void performFinish(IProgressMonitor iProgressMonitor) {
        final IMarkerResolution iMarkerResolution = this.getSelectedResolution();
        if (iMarkerResolution == null) {
            return;
        }
        final Object[] objectArray = this.markersTable.getCheckedElements();
        if (objectArray.length == 0) {
            return;
        }
        if (iMarkerResolution instanceof WorkbenchMarkerResolution) {
            try {
                this.getWizard().getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        IMarker[] iMarkerArray = new IMarker[objectArray.length];
                        System.arraycopy(objectArray, 0, iMarkerArray, 0, objectArray.length);
                        ((WorkbenchMarkerResolution)iMarkerResolution).run(iMarkerArray, iProgressMonitor);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(invocationTargetException));
            }
            catch (InterruptedException interruptedException) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(interruptedException));
            }
        } else {
            try {
                this.getWizard().getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, objectArray.length);
                        int n = 0;
                        while (n < objectArray.length) {
                            QuickFixPage.this.getShell().getDisplay().readAndDispatch();
                            if (iProgressMonitor.isCanceled()) {
                                return;
                            }
                            IMarker iMarker = (IMarker)objectArray[n];
                            iProgressMonitor.subTask(Util.getProperty("message", iMarker));
                            iMarkerResolution.run(iMarker);
                            iProgressMonitor.worked(1);
                            ++n;
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(invocationTargetException));
            }
            catch (InterruptedException interruptedException) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(interruptedException));
            }
        }
    }

    private IMarkerResolution getSelectedResolution() {
        ISelection iSelection = this.resolutionsList.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        return (IMarkerResolution)object;
    }
}

