/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.QuickFixPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class QuickFixWizard
extends Wizard {
    private Map resolutionMap;
    private String description;
    private IWorkbenchPartSite partSite;

    public QuickFixWizard(String string, Map map, IWorkbenchPartSite iWorkbenchPartSite) {
        this.resolutionMap = map;
        this.description = string;
        this.partSite = iWorkbenchPartSite;
        this.setDefaultPageImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_QUICKFIX_DLG"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new QuickFixPage(this.description, this.resolutionMap, this.partSite));
    }

    public boolean performFinish() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                IWizardPage[] iWizardPageArray = QuickFixWizard.this.getPages();
                iProgressMonitor.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, 10 * iWizardPageArray.length + 1);
                iProgressMonitor.worked(1);
                int n = 0;
                while (n < iWizardPageArray.length) {
                    QuickFixWizard.this.getShell().getDisplay().readAndDispatch();
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    QuickFixPage quickFixPage = (QuickFixPage)iWizardPageArray[n];
                    quickFixPage.performFinish((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                    iProgressMonitor.worked(1);
                    ++n;
                }
                iProgressMonitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException));
            return false;
        }
        catch (InterruptedException interruptedException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, interruptedException.getLocalizedMessage(), (Throwable)interruptedException));
            return false;
        }
        return true;
    }
}

