/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class ScopeArea
extends GroupFilterConfigurationArea {
    private Button[] buttons;
    int scope;
    private WorkingSetArea workingSetArea;

    public void applyToGroup(MarkerFieldFilterGroup markerFieldFilterGroup) {
        markerFieldFilterGroup.setScope(this.scope);
        markerFieldFilterGroup.setWorkingSet(this.workingSetArea.getWorkingSet());
    }

    public void createContents(Composite composite) {
        this.buttons = new Button[5];
        this.buttons[0] = this.createRadioButton(composite, MarkerMessages.filtersDialog_anyResource, 0);
        this.buttons[3] = this.createRadioButton(composite, MarkerMessages.filtersDialog_anyResourceInSameProject, 3);
        this.buttons[1] = this.createRadioButton(composite, MarkerMessages.filtersDialog_selectedResource, 1);
        this.buttons[2] = this.createRadioButton(composite, MarkerMessages.filtersDialog_selectedAndChildren, 2);
        this.workingSetArea = new WorkingSetArea(composite);
        this.buttons[4] = this.workingSetArea.getRadioButton();
    }

    protected Button createRadioButton(Composite composite, String string, final int n) {
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setSelection(n == this.scope);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScopeArea.this.scope = n;
            }
        });
        return button;
    }

    public String getTitle() {
        return MarkerMessages.filtersDialog_scopeTitle;
    }

    public void initializeFromGroup(MarkerFieldFilterGroup markerFieldFilterGroup) {
        this.buttons[this.scope].setSelection(false);
        this.scope = markerFieldFilterGroup.getScope();
        this.buttons[this.scope].setSelection(true);
        this.workingSetArea.setWorkingSet(markerFieldFilterGroup.getWorkingSet());
    }

    public void apply(MarkerFieldFilter markerFieldFilter) {
    }

    public void initialize(MarkerFieldFilter markerFieldFilter) {
    }

    private class WorkingSetArea {
        Button button;
        Button selectButton;

        WorkingSetArea(Composite composite) {
            this.button = ScopeArea.this.createRadioButton(composite, MarkerMessages.filtersDialog_noWorkingSet, 4);
            GridData gridData = new GridData(768);
            this.button.setLayoutData((Object)gridData);
            this.selectButton = new Button(composite, 8);
            this.selectButton.setText(MarkerMessages.filtersDialog_workingSetSelect);
            ScopeArea.this.initializeFontMetrics((Control)composite);
            GridData gridData2 = new GridData();
            gridData2.horizontalIndent = 21;
            int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)ScopeArea.this.getFontMetrics(), (int)61);
            Point point = this.selectButton.computeSize(-1, -1, true);
            gridData2.widthHint = Math.max(n, point.x);
            this.selectButton.setLayoutData((Object)gridData2);
            this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetArea this$1;
                {
                    this.this$1 = workingSetArea;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    IWorkingSetSelectionDialog iWorkingSetSelectionDialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(this.this$1.button.getShell(), false);
                    IWorkingSet iWorkingSet = this.this$1.getWorkingSet();
                    if (iWorkingSet != null) {
                        iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
                    }
                    if (iWorkingSetSelectionDialog.open() == 0) {
                        IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
                        if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                            this.this$1.setWorkingSet(iWorkingSetArray[0]);
                        } else {
                            this.this$1.setWorkingSet(null);
                        }
                        if (!this.this$1.getSelection()) {
                            this.this$1.setSelection(true);
                        }
                    }
                }
            });
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean bl) {
            this.button.setSelection(bl);
        }

        void setWorkingSet(IWorkingSet iWorkingSet) {
            this.button.setData((Object)iWorkingSet);
            if (iWorkingSet != null) {
                this.button.setText(NLS.bind((String)MarkerMessages.filtersDialog_workingSet, (Object)iWorkingSet.getLabel()));
            } else {
                this.button.setText(MarkerMessages.filtersDialog_noWorkingSet);
            }
        }

        Button getRadioButton() {
            return this.button;
        }
    }
}

