/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.markers.DescriptionConfigurationArea;
import org.eclipse.ui.internal.views.markers.SeverityAndDescriptionFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class SeverityAndDescriptionConfigurationArea
extends DescriptionConfigurationArea {
    private int severities;
    private Button infoButton;
    private Button errorButton;
    private Button warningButton;
    private Label label;

    public void apply(MarkerFieldFilter markerFieldFilter) {
        super.apply(markerFieldFilter);
        ((SeverityAndDescriptionFieldFilter)markerFieldFilter).selectedSeverities = this.severities;
    }

    Composite createSeverityGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 4;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.label = new Label(composite2, 0);
        this.label.setText(MarkerMessages.filtersDialog_severityLabel);
        this.errorButton = new Button(composite2, 32);
        this.errorButton.setText(MarkerMessages.filtersDialog_severityError);
        this.errorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SeverityAndDescriptionConfigurationArea.this.updateSeverities(4, SeverityAndDescriptionConfigurationArea.this.errorButton.getSelection());
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalIndent = 4;
        this.errorButton.setLayoutData((Object)gridData);
        this.warningButton = new Button(composite2, 32);
        this.warningButton.setText(MarkerMessages.filtersDialog_severityWarning);
        this.warningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SeverityAndDescriptionConfigurationArea.this.updateSeverities(2, SeverityAndDescriptionConfigurationArea.this.warningButton.getSelection());
            }
        });
        this.infoButton = new Button(composite2, 32);
        this.infoButton.setText(MarkerMessages.filtersDialog_severityInfo);
        this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SeverityAndDescriptionConfigurationArea.this.updateSeverities(1, SeverityAndDescriptionConfigurationArea.this.infoButton.getSelection());
            }
        });
        return composite2;
    }

    public void initialize(MarkerFieldFilter markerFieldFilter) {
        super.initialize(markerFieldFilter);
        SeverityAndDescriptionFieldFilter severityAndDescriptionFieldFilter = (SeverityAndDescriptionFieldFilter)markerFieldFilter;
        this.severities = severityAndDescriptionFieldFilter.selectedSeverities;
        this.infoButton.setSelection((1 & this.severities) > 0);
        this.warningButton.setSelection((2 & this.severities) > 0);
        this.errorButton.setSelection((4 & this.severities) > 0);
    }

    private void updateSeverities(int n, boolean bl) {
        this.severities = bl ? n | this.severities : n ^ this.severities;
    }

    void setSeverityButtonsEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.errorButton.setEnabled(bl);
        this.infoButton.setEnabled(bl);
        this.warningButton.setEnabled(bl);
    }
}

