/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkersContribution;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class SortFieldContribution
extends MarkersContribution {
    public SortFieldContribution() {
    }

    public SortFieldContribution(String string) {
        super(string);
    }

    protected IContributionItem[] getContributionItems() {
        MarkerField[] markerFieldArray = this.getView().getVisibleFields();
        if (markerFieldArray.length == 0) {
            return new IContributionItem[0];
        }
        IContributionItem[] iContributionItemArray = new IContributionItem[markerFieldArray.length + 2];
        int n = 0;
        while (n < markerFieldArray.length) {
            iContributionItemArray[n] = this.getContributionItem(markerFieldArray[n]);
            ++n;
        }
        iContributionItemArray[markerFieldArray.length] = new Separator();
        iContributionItemArray[markerFieldArray.length + 1] = this.getDirectionContribution();
        return iContributionItemArray;
    }

    private IContributionItem getDirectionContribution() {
        return new ContributionItem(){

            public void fill(Menu menu, int n) {
                MenuItem menuItem = new MenuItem(menu, 32);
                menuItem.setText(MarkerMessages.sortDirectionAscending_text);
                ExtendedMarkersView extendedMarkersView = SortFieldContribution.this.getView();
                menuItem.addListener(13, new Listener(this, extendedMarkersView){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ExtendedMarkersView val$view;
                    {
                        this.this$1 = var1_1;
                        this.val$view = extendedMarkersView;
                    }

                    public void handleEvent(Event event) {
                        if (this.val$view != null) {
                            this.val$view.toggleSortDirection();
                        }
                    }
                });
                if (extendedMarkersView != null) {
                    menuItem.setSelection(extendedMarkersView.getSortAscending());
                }
            }
        };
    }

    private IContributionItem getContributionItem(final MarkerField markerField) {
        return new ContributionItem(){

            public void fill(Menu menu, int n) {
                MenuItem menuItem = new MenuItem(menu, 16);
                String string = markerField.getColumnHeaderText();
                if (string.length() == 0) {
                    string = markerField.getColumnTooltipText();
                }
                menuItem.setText(string);
                ExtendedMarkersView extendedMarkersView = SortFieldContribution.this.getView();
                menuItem.addListener(13, this.getMenuItemListener(markerField, extendedMarkersView));
                if (extendedMarkersView != null) {
                    menuItem.setSelection(extendedMarkersView.isPrimarySortField(markerField));
                }
            }

            private Listener getMenuItemListener(MarkerField markerField2, ExtendedMarkersView extendedMarkersView) {
                return new Listener(this, extendedMarkersView, markerField2){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ ExtendedMarkersView val$view;
                    private final /* synthetic */ MarkerField val$field;
                    {
                        this.this$1 = var1_1;
                        this.val$view = extendedMarkersView;
                        this.val$field = markerField;
                    }

                    public void handleEvent(Event event) {
                        MenuItem menuItem = (MenuItem)event.widget;
                        if (menuItem.getSelection() && this.val$view != null) {
                            this.val$view.setPrimarySortField(this.val$field);
                        }
                    }
                };
            }
        };
    }
}

