/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerTypeFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;

public class TypesConfigurationArea
extends GroupFilterConfigurationArea {
    private static Collection EMPTY_COLLECTION = new HashSet();
    private HashMap models = new HashMap(0);
    private CheckboxTreeViewer typesViewer;

    public void apply(MarkerFieldFilter markerFieldFilter) {
        ArrayList<MarkerType> arrayList = new ArrayList<MarkerType>();
        Object[] objectArray = this.typesViewer.getCheckedElements();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof MarkerTypeEntry) {
                arrayList.add(((MarkerTypeEntry)objectArray[n]).getMarkerType());
            }
            ++n;
        }
        MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)this.typesViewer.getInput();
        ((MarkerTypeFieldFilter)markerFieldFilter).setSelectedTypes(arrayList, markerFieldFilterGroup.builder.getGenerator());
    }

    public void applyToGroup(MarkerFieldFilterGroup markerFieldFilterGroup) {
    }

    public void createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Tree tree = new Tree(composite2, 68386);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(false);
        TableLayout tableLayout = new TableLayout();
        tree.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        new TreeColumn(tree, 0, 0);
        this.typesViewer = new CheckboxTreeViewer(tree);
        this.initializeFontMetrics((Control)tree);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)100);
        gridData.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)75);
        final ITreeContentProvider iTreeContentProvider = this.getTypesContentProvider();
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)iTreeContentProvider);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((TypesEntry)object).getLabel();
            }
        });
        this.typesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return ((TypesEntry)object).getLabel().compareTo(((TypesEntry)object2).getLabel());
            }
        });
        this.typesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                this.setChildrenChecked(object, bl);
                this.setParentCheckState(object, bl);
            }

            private void setChildrenChecked(Object object, boolean bl) {
                Object[] objectArray = iTreeContentProvider.getChildren(object);
                if (objectArray.length > 0) {
                    int n = 0;
                    while (n < objectArray.length) {
                        TypesConfigurationArea.this.typesViewer.setChecked(objectArray[n], bl);
                        ++n;
                    }
                }
            }

            private void setParentCheckState(Object object, boolean bl) {
                Object object2 = iTreeContentProvider.getParent(object);
                if (object2 == null) {
                    return;
                }
                Object[] objectArray = iTreeContentProvider.getChildren(object2);
                int n = 0;
                while (n < objectArray.length) {
                    if (TypesConfigurationArea.this.typesViewer.getChecked(objectArray[n]) != bl) {
                        TypesConfigurationArea.this.typesViewer.setGrayChecked(object2, true);
                        return;
                    }
                    ++n;
                }
                TypesConfigurationArea.this.typesViewer.setChecked(object2, bl);
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 1;
        composite3.setLayoutData((Object)gridData2);
        Button button = new Button(composite3, 8);
        button.setText(MarkerMessages.filtersDialog_selectAllTypes);
        button.addSelectionListener(this.getSelectAllButtonListener(iTreeContentProvider, true));
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite3, 8);
        button2.setText(MarkerMessages.filtersDialog_deselectAllTypes);
        button2.addSelectionListener(this.getSelectAllButtonListener(iTreeContentProvider, false));
        this.setButtonLayoutData(button2);
    }

    public boolean grabExcessVerticalSpace() {
        return true;
    }

    private SelectionListener getSelectAllButtonListener(final ITreeContentProvider iTreeContentProvider, final boolean bl) {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] objectArray = iTreeContentProvider.getElements(TypesConfigurationArea.this.typesViewer.getInput());
                int n = 0;
                while (n < objectArray.length) {
                    TypesConfigurationArea.this.typesViewer.setSubtreeChecked(objectArray[n], bl);
                    ++n;
                }
            }
        };
    }

    protected List elementsForGroup(MarkerFieldFilterGroup markerFieldFilterGroup) {
        if (this.models.containsKey(markerFieldFilterGroup)) {
            return (List)this.models.get(markerFieldFilterGroup);
        }
        Iterator iterator = markerFieldFilterGroup.getAllTypes().iterator();
        ArrayList<TypesEntry> arrayList = new ArrayList<TypesEntry>();
        HashMap<String, CategoryEntry> hashMap = new HashMap<String, CategoryEntry>();
        while (iterator.hasNext()) {
            CategoryEntry categoryEntry;
            MarkerType markerType = (MarkerType)iterator.next();
            String string = MarkerSupportRegistry.getInstance().getCategory(markerType.getId());
            if (string == null) {
                arrayList.add(new MarkerTypeEntry(markerType));
                continue;
            }
            if (hashMap.containsKey(string)) {
                categoryEntry = (CategoryEntry)hashMap.get(string);
            } else {
                categoryEntry = new CategoryEntry(string);
                hashMap.put(string, categoryEntry);
                arrayList.add(categoryEntry);
            }
            MarkerTypeEntry markerTypeEntry = new MarkerTypeEntry(markerType);
            categoryEntry.add(markerTypeEntry);
        }
        this.models.put(markerFieldFilterGroup, arrayList);
        return arrayList;
    }

    private void findTypeEntries(MarkerFieldFilterGroup markerFieldFilterGroup, Collection collection, Collection collection2) {
        Iterator iterator = this.elementsForGroup(markerFieldFilterGroup).iterator();
        Collection collection3 = ((MarkerTypeFieldFilter)markerFieldFilterGroup.getFilter(this.getField())).getSelectedTypes();
        block0: while (iterator.hasNext()) {
            TypesEntry typesEntry = (TypesEntry)iterator.next();
            typesEntry.addElementsMatching(collection3, collection);
            if (!typesEntry.hasChildren()) continue;
            Collection collection4 = typesEntry.getChildren();
            if (collection.containsAll(collection4)) {
                collection.add(typesEntry);
                continue;
            }
            Iterator iterator2 = collection4.iterator();
            while (iterator2.hasNext()) {
                if (!collection.contains(iterator2.next())) continue;
                collection2.add(typesEntry);
                continue block0;
            }
        }
    }

    private ITreeContentProvider getTypesContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object object) {
                return ((TypesEntry)object).getChildren().toArray();
            }

            public Object[] getElements(Object object) {
                return TypesConfigurationArea.this.elementsForGroup((MarkerFieldFilterGroup)object).toArray();
            }

            public Object getParent(Object object) {
                return ((TypesEntry)object).getParent();
            }

            public boolean hasChildren(Object object) {
                return ((TypesEntry)object).hasChildren();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        };
    }

    public void initialize(MarkerFieldFilter markerFieldFilter) {
    }

    public void initializeFromGroup(MarkerFieldFilterGroup markerFieldFilterGroup) {
        this.typesViewer.setInput((Object)markerFieldFilterGroup);
        this.typesViewer.refresh();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.findTypeEntries(markerFieldFilterGroup, hashSet, hashSet2);
        this.typesViewer.setCheckedElements(hashSet.toArray());
        this.typesViewer.setGrayedElements(hashSet2.toArray());
    }

    public String getTitle() {
        return MarkerMessages.filtersDialog_typesTitle;
    }

    private class CategoryEntry
    extends TypesEntry {
        private Collection children = new ArrayList();
        private String name;

        public CategoryEntry(String string) {
            this.name = string;
        }

        public void add(MarkerTypeEntry markerTypeEntry) {
            this.children.add(markerTypeEntry);
            markerTypeEntry.setParent(this);
        }

        public void addElementsMatching(Collection collection, Collection collection2) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((MarkerTypeEntry)iterator.next()).addElementsMatching(collection, collection2);
            }
        }

        public Collection getChildren() {
            return this.children;
        }

        public String getLabel() {
            return this.name;
        }

        public TypesEntry getParent() {
            return null;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    private class MarkerTypeEntry
    extends TypesEntry {
        private CategoryEntry category;
        private MarkerType markerType;

        public MarkerTypeEntry(MarkerType markerType) {
            this.markerType = markerType;
        }

        public void addElementsMatching(Collection collection, Collection collection2) {
            if (collection.contains(this.markerType)) {
                collection2.add(this);
            }
        }

        public Collection getChildren() {
            return EMPTY_COLLECTION;
        }

        public String getLabel() {
            return this.markerType.getLabel();
        }

        public MarkerType getMarkerType() {
            return this.markerType;
        }

        public TypesEntry getParent() {
            return this.category;
        }

        public boolean hasChildren() {
            return false;
        }

        public void setParent(CategoryEntry categoryEntry) {
            this.category = categoryEntry;
        }
    }

    private abstract class TypesEntry {
        private TypesEntry() {
        }

        public abstract void addElementsMatching(Collection var1, Collection var2);

        public abstract Collection getChildren();

        public abstract String getLabel();

        public abstract TypesEntry getParent();

        public abstract boolean hasChildren();
    }
}

