/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.ZipFileExporter;

public class ArchiveFileExportOperation
implements IRunnableWithProgress {
    private IFileExporter exporter;
    private String destinationFilename;
    private IProgressMonitor monitor;
    private List resourcesToExport;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean useTarFormat = false;
    private boolean createLeadupStructure = true;

    public ArchiveFileExportOperation(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!this.isDescendent(list, iResource)) continue;
            iterator.remove();
        }
        this.resourcesToExport = list;
        this.destinationFilename = string;
    }

    public ArchiveFileExportOperation(IResource iResource, String string) {
        this.resource = iResource;
        this.destinationFilename = string;
    }

    public ArchiveFileExportOperation(IResource iResource, List list, String string) {
        this(iResource, string);
        this.resourcesToExport = list;
    }

    protected void addError(String string, Throwable throwable) {
        this.errorTable.add(new Status(4, "org.eclipse.ui.ide", 0, string, throwable));
    }

    protected int countChildrenOf(IResource iResource) throws CoreException {
        if (iResource.getType() == 1) {
            return 1;
        }
        int n = 0;
        if (iResource.isAccessible()) {
            IResource[] iResourceArray = ((IContainer)iResource).members();
            int n2 = 0;
            while (n2 < iResourceArray.length) {
                n += this.countChildrenOf(iResourceArray[n2]);
                ++n2;
            }
        }
        return n;
    }

    protected int countSelectedResources() throws CoreException {
        int n = 0;
        Iterator iterator = this.resourcesToExport.iterator();
        while (iterator.hasNext()) {
            n += this.countChildrenOf((IResource)iterator.next());
        }
        return n;
    }

    protected void exportResource(IResource iResource) throws InterruptedException {
        this.exportResource(iResource, 1);
    }

    protected void exportResource(IResource iResource, int n) throws InterruptedException {
        if (!iResource.isAccessible()) {
            return;
        }
        if (iResource.getType() == 1) {
            IPath iPath = iResource.getFullPath();
            String string = this.createLeadupStructure ? iPath.makeRelative().toString() : iPath.removeFirstSegments(iPath.segmentCount() - n).toString();
            this.monitor.subTask(string);
            try {
                this.exporter.write((IFile)iResource, string);
            }
            catch (IOException iOException) {
                this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)iResource.getFullPath().makeRelative(), (Object)iOException.getMessage()), iOException);
            }
            catch (CoreException coreException) {
                this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)iResource.getFullPath().makeRelative(), (Object)coreException.getMessage()), coreException);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        } else {
            IResource[] iResourceArray = null;
            try {
                iResourceArray = ((IContainer)iResource).members();
            }
            catch (CoreException coreException) {
                this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)iResource.getFullPath()), coreException);
            }
            int n2 = 0;
            while (n2 < iResourceArray.length) {
                this.exportResource(iResourceArray[n2], n + 1);
                ++n2;
            }
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        Iterator iterator = this.resourcesToExport.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            this.exportResource(iResource);
        }
    }

    public IStatus getStatus() {
        IStatus[] iStatusArray = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(iStatusArray);
        return new MultiStatus("org.eclipse.ui.ide", 0, iStatusArray, DataTransferMessages.FileSystemExportOperation_problemsExporting, null);
    }

    protected void initialize() throws IOException {
        this.exporter = this.useTarFormat ? new TarFileExporter(this.destinationFilename, this.useCompression) : new ZipFileExporter(this.destinationFilename, this.useCompression);
    }

    protected boolean isDescendent(List list, IResource iResource) {
        if (iResource.getType() == 4) {
            return false;
        }
        IContainer iContainer = iResource.getParent();
        if (list.contains(iContainer)) {
            return true;
        }
        return this.isDescendent(list, (IResource)iContainer);
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        this.monitor = iProgressMonitor;
        try {
            this.initialize();
        }
        catch (IOException iOException) {
            throw new InvocationTargetException(iOException, NLS.bind((String)DataTransferMessages.ZipExport_cannotOpen, (Object)iOException.getMessage()));
        }
        try {
            int n = -1;
            try {
                n = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {}
            this.monitor.beginTask(DataTransferMessages.DataTransfer_exportingTitle, n);
            if (this.resourcesToExport == null) {
                this.exportResource(this.resource);
            } else {
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException iOException) {
                throw new InvocationTargetException(iOException, NLS.bind((String)DataTransferMessages.ZipExport_cannotClose, (Object)iOException.getMessage()));
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateLeadupStructure(boolean bl) {
        this.createLeadupStructure = bl;
    }

    public void setUseCompression(boolean bl) {
        this.useCompression = bl;
    }

    public void setUseTarFormat(boolean bl) {
        this.useTarFormat = bl;
    }
}

