/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExporter;

public class FileSystemExportOperation
implements IRunnableWithProgress {
    private IPath path;
    private IProgressMonitor monitor;
    private FileSystemExporter exporter = new FileSystemExporter();
    private List resourcesToExport;
    private IOverwriteQuery overwriteCallback;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private boolean createLeadupStructure = true;
    private boolean createContainerDirectories = true;

    public FileSystemExportOperation(IResource iResource, String string, IOverwriteQuery iOverwriteQuery) {
        this.resource = iResource;
        this.path = new Path(string);
        this.overwriteCallback = iOverwriteQuery;
    }

    public FileSystemExportOperation(IResource iResource, List list, String string, IOverwriteQuery iOverwriteQuery) {
        this(iResource, string, iOverwriteQuery);
        this.resourcesToExport = list;
    }

    protected int countChildrenOf(IResource iResource) throws CoreException {
        if (iResource.getType() == 1) {
            return 1;
        }
        int n = 0;
        if (iResource.isAccessible()) {
            IResource[] iResourceArray = ((IContainer)iResource).members();
            int n2 = 0;
            while (n2 < iResourceArray.length) {
                n += this.countChildrenOf(iResourceArray[n2]);
                ++n2;
            }
        }
        return n;
    }

    protected int countSelectedResources() throws CoreException {
        int n = 0;
        Iterator iterator = this.resourcesToExport.iterator();
        while (iterator.hasNext()) {
            n += this.countChildrenOf((IResource)iterator.next());
        }
        return n;
    }

    protected void createLeadupDirectoriesFor(IResource iResource) {
        IPath iPath = iResource.getFullPath().removeLastSegments(1);
        int n = 0;
        while (n < iPath.segmentCount()) {
            this.path = this.path.append(iPath.segment(n));
            this.exporter.createFolder(this.path);
            ++n;
        }
    }

    protected void exportAllResources() throws InterruptedException {
        if (this.resource.getType() == 1) {
            this.exportFile((IFile)this.resource, this.path);
        } else {
            try {
                this.exportChildren(((IContainer)this.resource).members(), this.path);
            }
            catch (CoreException coreException) {
                this.errorTable.add(coreException.getStatus());
            }
        }
    }

    protected void exportChildren(IResource[] iResourceArray, IPath iPath) throws InterruptedException {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.isAccessible()) {
                if (iResource.getType() == 1) {
                    this.exportFile((IFile)iResource, iPath);
                } else {
                    IPath iPath2 = iPath.append(iResource.getName());
                    this.exporter.createFolder(iPath2);
                    try {
                        this.exportChildren(((IContainer)iResource).members(), iPath2);
                    }
                    catch (CoreException coreException) {
                        this.errorTable.add(coreException.getStatus());
                    }
                }
            }
            ++n;
        }
    }

    protected void exportFile(IFile iFile, IPath iPath) throws InterruptedException {
        IPath iPath2 = iPath.append(iFile.getName());
        this.monitor.subTask(iFile.getFullPath().toString());
        String string = iPath2.toOSString();
        File file = new File(string);
        if (file.exists()) {
            if (!file.canWrite()) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.DataTransfer_cannotOverwrite, (Object)file.getAbsolutePath()), null));
                this.monitor.worked(1);
                return;
            }
            if (this.overwriteState == 1) {
                return;
            }
            if (this.overwriteState != 2) {
                String string2 = this.overwriteCallback.queryOverwrite(string);
                if (string2.equals("CANCEL")) {
                    throw new InterruptedException();
                }
                if (string2.equals("NO")) {
                    this.monitor.worked(1);
                    return;
                }
                if (string2.equals("NOALL")) {
                    this.monitor.worked(1);
                    this.overwriteState = 1;
                    return;
                }
                if (string2.equals("ALL")) {
                    this.overwriteState = 2;
                }
            }
        }
        try {
            this.exporter.write((IResource)iFile, iPath2);
        }
        catch (IOException iOException) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)iPath2, (Object)iOException.getMessage()), (Throwable)iOException));
        }
        catch (CoreException coreException) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)iPath2, (Object)coreException.getMessage()), (Throwable)coreException));
        }
        this.monitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        Iterator iterator = this.resourcesToExport.iterator();
        IPath iPath = (IPath)this.path.clone();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!iResource.isAccessible()) continue;
            this.path = iPath;
            if (this.resource == null) {
                if (this.createLeadupStructure) {
                    this.createLeadupDirectoriesFor(iResource);
                }
            } else {
                IPath iPath2 = iResource.getFullPath().removeFirstSegments(this.resource.getFullPath().segmentCount()).removeLastSegments(1);
                int n = 0;
                while (n < iPath2.segmentCount()) {
                    this.path = this.path.append(iPath2.segment(n));
                    this.exporter.createFolder(this.path);
                    ++n;
                }
            }
            if (iResource.getType() == 1) {
                this.exportFile((IFile)iResource, this.path);
                continue;
            }
            if (this.createContainerDirectories) {
                this.path = this.path.append(iResource.getName());
                this.exporter.createFolder(this.path);
            }
            try {
                this.exportChildren(((IContainer)iResource).members(), this.path);
            }
            catch (CoreException coreException) {
                this.errorTable.add(coreException.getStatus());
            }
        }
    }

    public IStatus getStatus() {
        IStatus[] iStatusArray = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(iStatusArray);
        return new MultiStatus("org.eclipse.ui", 0, iStatusArray, DataTransferMessages.FileSystemExportOperation_problemsExporting, null);
    }

    protected boolean isDescendent(List list, IResource iResource) {
        if (iResource.getType() == 4) {
            return false;
        }
        IContainer iContainer = iResource.getParent();
        if (list.contains(iContainer)) {
            return true;
        }
        return this.isDescendent(list, (IResource)iContainer);
    }

    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
        this.monitor = iProgressMonitor;
        if (this.resource != null) {
            if (this.createLeadupStructure) {
                this.createLeadupDirectoriesFor(this.resource);
            }
            if (this.createContainerDirectories && this.resource.getType() != 1) {
                this.path = this.path.append(this.resource.getName());
                this.exporter.createFolder(this.path);
            }
        }
        try {
            int n = -1;
            try {
                n = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {
                this.errorTable.add(coreException.getStatus());
            }
            this.monitor.beginTask(DataTransferMessages.DataTransfer_exportingTitle, n);
            if (this.resourcesToExport == null) {
                this.exportAllResources();
            } else {
                this.exportSpecifiedResources();
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateContainerDirectories(boolean bl) {
        this.createContainerDirectories = bl;
    }

    public void setCreateLeadupStructure(boolean bl) {
        this.createLeadupStructure = bl;
    }

    public void setOverwriteFiles(boolean bl) {
        if (bl) {
            this.overwriteState = 2;
        }
    }
}

