/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class FileSystemExporter {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    public void createFolder(IPath iPath) {
        new File(iPath.toOSString()).mkdir();
    }

    public void write(IResource iResource, IPath iPath) throws CoreException, IOException {
        if (iResource.getType() == 1) {
            this.writeFile((IFile)iResource, iPath);
        } else {
            this.writeChildren((IContainer)iResource, iPath);
        }
    }

    protected void writeChildren(IContainer iContainer, IPath iPath) throws CoreException, IOException {
        if (iContainer.isAccessible()) {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                this.writeResource(iResource, iPath.append(iResource.getName()));
                ++n;
            }
        }
    }

    protected void writeFile(IFile iFile, IPath iPath) throws IOException, CoreException {
        OutputStream outputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(iFile.getContents(false));
            outputStream = new BufferedOutputStream(new FileOutputStream(iPath.toOSString()));
            int n = ((InputStream)bufferedInputStream).available();
            n = n <= 0 ? 16384 : n;
            int n2 = Math.min(16384, n);
            byte[] byArray = new byte[n2];
            int n3 = ((InputStream)bufferedInputStream).read(byArray);
            while (n3 > 0) {
                outputStream.write(byArray, 0, n3);
                n3 = ((InputStream)bufferedInputStream).read(byArray);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {
                    IDEWorkbenchPlugin.log("Error closing input stream for file: " + iFile.getLocation(), iOException);
                }
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected void writeResource(IResource iResource, IPath iPath) throws CoreException, IOException {
        if (iResource.getType() == 1) {
            this.writeFile((IFile)iResource, iPath);
        } else {
            this.createFolder(iPath);
            this.writeChildren((IContainer)iResource, iPath);
        }
    }
}

