/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class MinimizedFileSystemElement
extends FileSystemElement {
    private boolean populated = false;

    public MinimizedFileSystemElement(String string, FileSystemElement fileSystemElement, boolean bl) {
        super(string, fileSystemElement, bl);
    }

    public AdaptableList getFiles(IImportStructureProvider iImportStructureProvider) {
        if (!this.populated) {
            this.populate(iImportStructureProvider);
        }
        return super.getFiles();
    }

    public AdaptableList getFolders(IImportStructureProvider iImportStructureProvider) {
        if (!this.populated) {
            this.populate(iImportStructureProvider);
        }
        return super.getFolders();
    }

    boolean isPopulated() {
        return this.populated;
    }

    private void populate(IImportStructureProvider iImportStructureProvider) {
        Object object = this.getFileSystemObject();
        ArrayList arrayList = iImportStructureProvider.getChildren(object);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = iImportStructureProvider.getLabel(e);
            MinimizedFileSystemElement minimizedFileSystemElement = new MinimizedFileSystemElement(string, this, iImportStructureProvider.isFolder(e));
            minimizedFileSystemElement.setFileSystemObject(e);
        }
        this.setPopulated();
    }

    public void setPopulated() {
        this.populated = true;
    }
}

