/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarInputStream;

public class TarFile {
    private File file;
    private TarInputStream entryEnumerationStream;
    private TarEntry curEntry;
    private TarInputStream entryStream;
    private InputStream internalEntryStream;

    public TarFile(File file) throws TarException, IOException {
        this.file = file;
        InputStream inputStream = new FileInputStream(file);
        try {
            inputStream = new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            inputStream.close();
            inputStream = new FileInputStream(file);
        }
        try {
            this.entryEnumerationStream = new TarInputStream(inputStream);
        }
        catch (TarException tarException) {
            inputStream.close();
            throw tarException;
        }
        this.curEntry = this.entryEnumerationStream.getNextEntry();
    }

    public void close() throws IOException {
        if (this.entryEnumerationStream != null) {
            this.entryEnumerationStream.close();
        }
        if (this.internalEntryStream != null) {
            this.internalEntryStream.close();
        }
    }

    public TarFile(String string) throws TarException, IOException {
        this(new File(string));
    }

    public Enumeration entries() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return TarFile.this.curEntry != null;
            }

            public Object nextElement() {
                TarEntry tarEntry = TarFile.this.curEntry;
                try {
                    TarFile.this.curEntry = TarFile.this.entryEnumerationStream.getNextEntry();
                }
                catch (TarException tarException) {
                    TarFile.this.curEntry = null;
                }
                catch (IOException iOException) {
                    TarFile.this.curEntry = null;
                }
                return tarEntry;
            }
        };
    }

    public InputStream getInputStream(TarEntry tarEntry) throws TarException, IOException {
        if (this.entryStream == null || !this.entryStream.skipToEntry(tarEntry)) {
            if (this.internalEntryStream != null) {
                this.internalEntryStream.close();
            }
            this.internalEntryStream = new FileInputStream(this.file);
            try {
                this.internalEntryStream = new GZIPInputStream(this.internalEntryStream);
            }
            catch (IOException iOException) {
                this.internalEntryStream.close();
                this.internalEntryStream = new FileInputStream(this.file);
            }
            this.entryStream = new TarInputStream(this.internalEntryStream, tarEntry){

                public void close() {
                }
            };
        }
        return this.entryStream;
    }

    public String getName() {
        return this.file.getPath();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

