/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarOutputStream;

public class TarFileExporter
implements IFileExporter {
    private TarOutputStream outputStream;
    private GZIPOutputStream gzipOutputStream;

    public TarFileExporter(String string, boolean bl) throws IOException {
        if (bl) {
            this.gzipOutputStream = new GZIPOutputStream(new FileOutputStream(string));
            this.outputStream = new TarOutputStream(new BufferedOutputStream(this.gzipOutputStream));
        } else {
            this.outputStream = new TarOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        }
    }

    public void finished() throws IOException {
        this.outputStream.close();
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
    }

    private void write(TarEntry tarEntry, IFile iFile) throws IOException, CoreException {
        URI uRI = iFile.getLocationURI();
        if (uRI == null) {
            throw new FileNotFoundException(iFile.getFullPath().toOSString());
        }
        InputStream inputStream = iFile.getContents(false);
        tarEntry.setSize(EFS.getStore((URI)uRI).fetchInfo().getLength());
        this.outputStream.putNextEntry(tarEntry);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                this.outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.outputStream.closeEntry();
    }

    public void write(IFile iFile, String string) throws IOException, CoreException {
        ResourceAttributes resourceAttributes;
        TarEntry tarEntry = new TarEntry(string);
        if (iFile.getLocalTimeStamp() != -1L) {
            tarEntry.setTime(iFile.getLocalTimeStamp() / 1000L);
        }
        if ((resourceAttributes = iFile.getResourceAttributes()) != null && resourceAttributes.isExecutable()) {
            tarEntry.setMode(tarEntry.getMode() | 0x49L);
        }
        if (resourceAttributes != null && resourceAttributes.isReadOnly()) {
            tarEntry.setMode(tarEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        this.write(tarEntry, iFile);
    }
}

