/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;

public class TarLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private TarFile tarFile;
    private TarEntry root = new TarEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();
    private int stripLevel;

    public TarLeveledStructureProvider(TarFile tarFile) {
        this.tarFile = tarFile;
        this.root.setFileType(53);
    }

    protected TarEntry createContainer(IPath iPath) {
        TarEntry tarEntry = (TarEntry)this.directoryEntryCache.get(iPath);
        if (tarEntry != null) {
            return tarEntry;
        }
        TarEntry tarEntry2 = iPath.segmentCount() == 1 ? this.root : this.createContainer(iPath.removeLastSegments(1));
        TarEntry tarEntry3 = new TarEntry(iPath.toString());
        tarEntry3.setFileType(53);
        this.directoryEntryCache.put(iPath, tarEntry3);
        ArrayList arrayList = new ArrayList();
        this.children.put(tarEntry3, arrayList);
        List list = (List)this.children.get(tarEntry2);
        list.add(tarEntry3);
        return tarEntry3;
    }

    protected void createFile(TarEntry tarEntry) {
        Path path = new Path(tarEntry.getName());
        TarEntry tarEntry2 = path.segmentCount() == 1 ? this.root : (TarEntry)this.directoryEntryCache.get(path.removeLastSegments(1));
        List list = (List)this.children.get(tarEntry2);
        list.add(tarEntry);
    }

    public List getChildren(Object object) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(object);
    }

    public InputStream getContents(Object object) {
        try {
            return this.tarFile.getInputStream((TarEntry)object);
        }
        catch (TarException tarException) {
            IDEWorkbenchPlugin.log(tarException.getLocalizedMessage(), tarException);
            return null;
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.log(iOException.getLocalizedMessage(), iOException);
            return null;
        }
    }

    public ResourceAttributes getResourceAttributes(Object object) {
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        TarEntry tarEntry = (TarEntry)object;
        resourceAttributes.setExecutable((tarEntry.getMode() & 0x40L) != 0L);
        resourceAttributes.setReadOnly((tarEntry.getMode() & 0x80L) == 0L);
        return resourceAttributes;
    }

    public String getFullPath(Object object) {
        return this.stripPath(((TarEntry)object).getName());
    }

    public String getLabel(Object object) {
        if (object.equals(this.root)) {
            return ((TarEntry)object).getName();
        }
        return this.stripPath(new Path(((TarEntry)object).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    public boolean closeArchive() {
        try {
            this.getTarFile().close();
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.log(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getTarFile().getName(), iOException);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration enumeration = this.tarFile.entries();
        while (enumeration.hasMoreElements()) {
            TarEntry tarEntry = (TarEntry)enumeration.nextElement();
            IPath iPath = new Path(tarEntry.getName()).addTrailingSeparator();
            if (tarEntry.getFileType() == 53) {
                this.createContainer(iPath);
                continue;
            }
            int n = iPath.segmentCount();
            if (n > 1) {
                this.createContainer(iPath.uptoSegment(n - 1));
            }
            this.createFile(tarEntry);
        }
    }

    public boolean isFolder(Object object) {
        return ((TarEntry)object).getFileType() == 53;
    }

    private String stripPath(String string) {
        String string2 = new String(string);
        int n = 0;
        while (n < this.stripLevel) {
            int n2 = string.indexOf(47);
            if (n2 == 0) {
                string = string.substring(1);
                n2 = string.indexOf(47);
            }
            if (n2 == -1) {
                return string2;
            }
            string = string.substring(n2);
            ++n;
        }
        return string;
    }

    public void setStrip(int n) {
        this.stripLevel = n;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

