/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    private int byteswritten = 0;
    private int datapos = 0;
    private long cursize = 0L;

    public TarOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void close() throws IOException {
        byte[] byArray = new byte[1024];
        this.cursize = 1024L;
        this.write(byArray, 0, 1024);
        if (this.byteswritten % 10240 != 0) {
            int n = 10240 - this.byteswritten % 10240;
            this.cursize = n;
            byArray = new byte[n];
            this.write(byArray, 0, n);
        }
        super.close();
    }

    public void closeEntry() throws IOException {
        byte[] byArray = new byte[512];
        int n = 512 - this.datapos;
        if (n > 0 && this.datapos > 0) {
            this.cursize = n;
            this.write(byArray, 0, n);
        }
    }

    private long headerChecksum(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < 512) {
            l += (long)(byArray[n] & 0xFF);
            ++n;
        }
        return l;
    }

    public void putNextEntry(TarEntry tarEntry) throws IOException {
        byte[] byArray = new byte[512];
        String string = tarEntry.getName();
        String string2 = null;
        byte[] byArray2 = string.getBytes("UTF8");
        if (byArray2.length > 99) {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                throw new IOException("filename too long");
            }
            string2 = string.substring(0, n);
            byArray2 = (string = string.substring(n + 1)).getBytes("UTF8");
            if (byArray2.length > 99) {
                throw new IOException("filename too long");
            }
        }
        int n = 0;
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        n += 100;
        StringBuffer stringBuffer = new StringBuffer(Long.toOctalString(tarEntry.getMode()));
        while (stringBuffer.length() < 7) {
            stringBuffer.insert(0, '0');
        }
        int n2 = 0;
        while (n2 < 7) {
            byArray[n + n2] = (byte)stringBuffer.charAt(n2);
            ++n2;
        }
        byArray[n += 8] = 48;
        byArray[n += 8] = 48;
        n += 8;
        String string3 = Long.toOctalString(tarEntry.getSize());
        n2 = 0;
        while (n2 < string3.length()) {
            byArray[n + n2] = (byte)string3.charAt(n2);
            ++n2;
        }
        n += 12;
        String string4 = Long.toOctalString(tarEntry.getTime());
        n2 = 0;
        while (n2 < string4.length()) {
            byArray[n + n2] = (byte)string4.charAt(n2);
            ++n2;
        }
        n += 12;
        n2 = 0;
        while (n2 < 8) {
            byArray[n + n2] = 32;
            ++n2;
        }
        byArray[n += 8] = (byte)tarEntry.getFileType();
        ++n;
        n += 100;
        String string5 = "ustar 00";
        n2 = 0;
        while (n2 < string5.length()) {
            byArray[n + n2] = (byte)string5.charAt(n2);
            ++n2;
        }
        byArray[n + 5] = 0;
        n += 8;
        String string6 = "nobody";
        n2 = 0;
        while (n2 < string6.length()) {
            byArray[n + n2] = (byte)string6.charAt(n2);
            ++n2;
        }
        n += 32;
        String string7 = "nobody";
        n2 = 0;
        while (n2 < string7.length()) {
            byArray[n + n2] = (byte)string7.charAt(n2);
            ++n2;
        }
        n += 32;
        n += 8;
        n += 8;
        if (string2 != null) {
            byte[] byArray3 = string2.getBytes("UTF8");
            if (byArray3.length > 155) {
                throw new IOException("prefix too large");
            }
            System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
        }
        long l = this.headerChecksum(byArray);
        n = 148;
        String string8 = Long.toOctalString(l);
        n2 = 0;
        while (n2 < string8.length()) {
            byArray[n + n2] = (byte)string8.charAt(n2);
            ++n2;
        }
        this.cursize = 512L;
        this.write(byArray, 0, 512);
        this.cursize = tarEntry.getSize();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.datapos = (this.datapos + n2) % 512;
        this.byteswritten += n2;
        this.cursize -= (long)n2;
        if (this.cursize < 0L) {
            throw new IOException("too much data written for current file");
        }
    }
}

