/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileExportOperation;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceExportPage1;

public class WizardArchiveFileResourceExportPage1
extends WizardFileSystemResourceExportPage1 {
    protected Button compressContentsCheckbox;
    private Button zipFormatButton;
    private Button targzFormatButton;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardZipFileResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardZipFileResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_COMPRESS_CONTENTS_ID = "WizardZipFileResourceExportPage1.STORE_COMPRESS_CONTENTS_ID";

    protected WizardArchiveFileResourceExportPage1(String string, IStructuredSelection iStructuredSelection) {
        super(string, iStructuredSelection);
    }

    public WizardArchiveFileResourceExportPage1(IStructuredSelection iStructuredSelection) {
        this("zipFileExportPage1", iStructuredSelection);
        this.setTitle(DataTransferMessages.ArchiveExport_exportTitle);
        this.setDescription(DataTransferMessages.ArchiveExport_description);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.zip_file_export_wizard_page");
    }

    protected void createOptionsGroupButtons(Group group) {
        Font font = group.getFont();
        group.setLayout((Layout)new GridLayout(2, true));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createFileFormatOptions(composite, font);
        this.compressContentsCheckbox = new Button(composite, 16416);
        this.compressContentsCheckbox.setText(DataTransferMessages.ZipExport_compressContents);
        this.compressContentsCheckbox.setFont(font);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(16384, 128, true, false));
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.createDirectoryStructureOptions(composite2, font);
        this.createDirectoryStructureButton.setSelection(true);
        this.createSelectionOnlyButton.setSelection(false);
        this.compressContentsCheckbox.setSelection(true);
    }

    protected void createFileFormatOptions(Composite composite, Font font) {
        this.zipFormatButton = new Button(composite, 16400);
        this.zipFormatButton.setText(DataTransferMessages.ArchiveExport_saveInZipFormat);
        this.zipFormatButton.setSelection(true);
        this.zipFormatButton.setFont(font);
        this.targzFormatButton = new Button(composite, 16400);
        this.targzFormatButton.setText(DataTransferMessages.ArchiveExport_saveInTarFormat);
        this.targzFormatButton.setSelection(false);
        this.targzFormatButton.setFont(font);
    }

    protected boolean ensureTargetDirectoryIsValid(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            return true;
        }
        return this.ensureTargetIsValid(new File(string.substring(0, n)));
    }

    protected boolean ensureTargetFileIsValid(File file) {
        if (file.exists() && file.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.ZipExport_mustBeFile);
            this.giveFocusToDestination();
            return false;
        }
        if (file.exists()) {
            if (file.canWrite()) {
                if (!this.queryYesNoQuestion(DataTransferMessages.ZipExport_alreadyExists)) {
                    return false;
                }
            } else {
                this.displayErrorDialog(DataTransferMessages.ZipExport_alreadyExistsError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String string = this.getDestinationValue();
        if (!this.ensureTargetDirectoryIsValid(string)) {
            return false;
        }
        return this.ensureTargetFileIsValid(new File(string));
    }

    protected boolean executeExportOperation(ArchiveFileExportOperation archiveFileExportOperation) {
        archiveFileExportOperation.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        archiveFileExportOperation.setUseCompression(this.compressContentsCheckbox.getSelection());
        archiveFileExportOperation.setUseTarFormat(this.targzFormatButton.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)archiveFileExportOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.displayErrorDialog(invocationTargetException.getTargetException());
            return false;
        }
        IStatus iStatus = archiveFileExportOperation.getStatus();
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_exportProblems, null, (IStatus)iStatus);
            return false;
        }
        return true;
    }

    public boolean finish() {
        List list = this.getWhiteCheckedResources();
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        this.saveDirtyEditors();
        this.saveWidgetValues();
        return this.executeExportOperation(new ArchiveFileExportOperation(null, list, this.getDestinationValue()));
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.ArchiveExport_destinationLabel;
    }

    protected String getDestinationValue() {
        String string = this.getOutputSuffix();
        String string2 = super.getDestinationValue();
        if (string2.length() != 0 && !string2.endsWith(File.separator)) {
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                int n2 = string2.lastIndexOf(File.separator);
                if (n2 != -1 && n < n2) {
                    string2 = String.valueOf(string2) + string;
                }
            } else {
                string2 = String.valueOf(string2) + string;
            }
        }
        return string2;
    }

    protected String getOutputSuffix() {
        if (this.zipFormatButton.getSelection()) {
            return ".zip";
        }
        if (this.compressContentsCheckbox.getSelection()) {
            return ".tar.gz";
        }
        return ".tar";
    }

    protected void handleDestinationBrowseButtonPressed() {
        String string;
        FileDialog fileDialog = new FileDialog(this.getContainer().getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"*.zip;*.tar.gz;*.tar;*.tgz", "*.*"});
        fileDialog.setText(DataTransferMessages.ArchiveExport_selectDestinationTitle);
        String string2 = this.getDestinationValue();
        int n = string2.lastIndexOf(File.separator);
        if (n != -1) {
            fileDialog.setFilterPath(string2.substring(0, n));
        }
        if ((string = fileDialog.open()) != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(string);
        }
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES_ID);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            stringArray = this.addToHistory(stringArray, this.getDestinationValue());
            iDialogSettings.put(STORE_DESTINATION_NAMES_ID, stringArray);
            iDialogSettings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
            iDialogSettings.put(STORE_COMPRESS_CONTENTS_ID, this.compressContentsCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES_ID);
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            this.setDestinationValue(stringArray[0]);
            boolean bl = false;
            while (bl < stringArray.length) {
                this.addDestinationItem(stringArray[bl]);
                bl += 1;
            }
            bl = iDialogSettings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(bl);
            this.createSelectionOnlyButton.setSelection(!bl);
            this.compressContentsCheckbox.setSelection(iDialogSettings.getBoolean(STORE_COMPRESS_CONTENTS_ID));
        }
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.ArchiveExport_destinationEmpty;
    }

    protected boolean validateDestinationGroup() {
        String string = this.getDestinationValue();
        if (string.endsWith(".tar")) {
            this.compressContentsCheckbox.setSelection(false);
            this.targzFormatButton.setSelection(true);
            this.zipFormatButton.setSelection(false);
        } else if (string.endsWith(".tar.gz") || string.endsWith(".tgz")) {
            this.compressContentsCheckbox.setSelection(true);
            this.targzFormatButton.setSelection(true);
            this.zipFormatButton.setSelection(false);
        } else if (string.endsWith(".zip")) {
            this.zipFormatButton.setSelection(true);
            this.targzFormatButton.setSelection(false);
        }
        return super.validateDestinationGroup();
    }
}

