/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardArchiveFileResourceImportPage1
extends WizardFileSystemResourceImportPage1
implements Listener {
    ILeveledImportStructureProvider structureProvider;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static final String STORE_SOURCE_NAMES_ID = "WizardZipFileResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardZipFileResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_SELECTED_TYPES_ID = "WizardZipFileResourceImportPage1.STORE_SELECTED_TYPES_ID";
    private final String[] fileImportMask;

    public WizardArchiveFileResourceImportPage1(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this(iWorkbench, iStructuredSelection, null);
    }

    public WizardArchiveFileResourceImportPage1(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, String[] stringArray) {
        super("zipFileImportPage1", iWorkbench, iStructuredSelection);
        this.setTitle(DataTransferMessages.ArchiveExport_exportTitle);
        this.setDescription(DataTransferMessages.ArchiveImport_description);
        this.fileImportMask = stringArray == null ? FILE_IMPORT_MASK : stringArray;
    }

    public boolean cancel() {
        this.disposeStructureProvider();
        return true;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.zip_file_import_wizard_page");
    }

    protected void createOptionsGroup(Composite composite) {
        this.overwriteExistingResourcesCheckbox = new Button(composite, 32);
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.FileImport_overwriteExisting);
        this.overwriteExistingResourcesCheckbox.setFont(composite.getFont());
    }

    private boolean validateSourceFile(String string) {
        if (ArchiveFileManipulations.isTarFile(string)) {
            TarFile tarFile = this.getSpecifiedTarSourceFile(string);
            if (tarFile != null) {
                ArchiveFileManipulations.closeTarFile(tarFile, this.getShell());
                return true;
            }
            return false;
        }
        ZipFile zipFile = this.getSpecifiedZipSourceFile(string);
        if (zipFile != null) {
            ArchiveFileManipulations.closeZipFile(zipFile, this.getShell());
            return true;
        }
        return false;
    }

    private boolean ensureZipSourceIsValid() {
        ZipFile zipFile = this.getSpecifiedZipSourceFile();
        if (zipFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeZipFile(zipFile, this.getShell());
    }

    private boolean ensureTarSourceIsValid() {
        TarFile tarFile = this.getSpecifiedTarSourceFile();
        if (tarFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeTarFile(tarFile, this.getShell());
    }

    protected boolean ensureSourceIsValid() {
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            return this.ensureTarSourceIsValid();
        }
        return this.ensureZipSourceIsValid();
    }

    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        this.disposeStructureProvider();
        return true;
    }

    private void disposeStructureProvider() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        this.structureProvider = null;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    AdaptableList adaptableList = minimizedFileSystemElement.getFiles(WizardArchiveFileResourceImportPage1.this.structureProvider);
                    return adaptableList.getChildren((Object)minimizedFileSystemElement);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        this.disposeStructureProvider();
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            TarFile tarFile = this.getSpecifiedTarSourceFile();
            if (tarFile == null) {
                return null;
            }
            this.structureProvider = new TarLeveledStructureProvider(tarFile);
            return this.selectFiles(this.structureProvider.getRoot(), this.structureProvider);
        }
        ZipFile zipFile = this.getSpecifiedZipSourceFile();
        if (zipFile == null) {
            return null;
        }
        this.structureProvider = new ZipLeveledStructureProvider(zipFile);
        return this.selectFiles(this.structureProvider.getRoot(), this.structureProvider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    AdaptableList adaptableList = minimizedFileSystemElement.getFolders(WizardArchiveFileResourceImportPage1.this.structureProvider);
                    return adaptableList.getChildren((Object)minimizedFileSystemElement);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    if (minimizedFileSystemElement.isPopulated()) {
                        return this.getChildren((Object)minimizedFileSystemElement).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected String getSourceLabel() {
        return DataTransferMessages.ArchiveImport_fromFile;
    }

    protected ZipFile getSpecifiedZipSourceFile() {
        return this.getSpecifiedZipSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedZipSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(string);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected TarFile getSpecifiedTarSourceFile() {
        return this.getSpecifiedTarSourceFile(this.sourceNameField.getText());
    }

    private TarFile getSpecifiedTarSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new TarFile(string);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected void handleSourceBrowseButtonPressed() {
        String string = this.queryZipFileToImport();
        if (string != null && !string.equals(this.sourceNameField.getText()) && this.validateSourceFile(string)) {
            this.setSourceName(string);
            this.selectionGroup.setFocus();
        }
    }

    protected boolean importResources(List list) {
        Object object;
        ILeveledImportStructureProvider iLeveledImportStructureProvider = null;
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            if (this.ensureTarSourceIsValid()) {
                object = this.getSpecifiedTarSourceFile();
                iLeveledImportStructureProvider = new TarLeveledStructureProvider((TarFile)object);
            }
        } else if (this.ensureZipSourceIsValid()) {
            object = this.getSpecifiedZipSourceFile();
            iLeveledImportStructureProvider = new ZipLeveledStructureProvider((ZipFile)object);
        }
        if (iLeveledImportStructureProvider == null) {
            return false;
        }
        object = new ImportOperation(this.getContainerFullPath(), iLeveledImportStructureProvider.getRoot(), iLeveledImportStructureProvider, this, list);
        ((ImportOperation)object).setContext(this.getShell());
        if (!this.executeImportOperation((ImportOperation)object)) {
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(iLeveledImportStructureProvider, this.getShell());
        return true;
    }

    protected void initializeOperation(ImportOperation importOperation) {
        importOperation.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected String queryZipFileToImport() {
        FileDialog fileDialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        fileDialog.setFilterExtensions(this.fileImportMask);
        fileDialog.setText(DataTransferMessages.ArchiveImportSource_title);
        String string = this.sourceNameField.getText();
        int n = string.lastIndexOf(File.separator);
        if (n != -1) {
            fileDialog.setFilterPath(string.substring(0, n));
        }
        return fileDialog.open();
    }

    protected void resetSelection() {
        super.resetSelection();
        this.setAllSelections(true);
    }

    protected void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_SOURCE_NAMES_ID);
            if (stringArray == null) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                this.sourceNameField.add(stringArray[n]);
                ++n;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(iDialogSettings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_SOURCE_NAMES_ID);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            stringArray = this.addToHistory(stringArray, this.sourceNameField.getText());
            iDialogSettings.put(STORE_SOURCE_NAMES_ID, stringArray);
            String[] stringArray2 = iDialogSettings.getArray(STORE_SELECTED_TYPES_ID);
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            iDialogSettings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }

    protected boolean validateSourceGroup() {
        if (this.structureProvider == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        List list = this.selectionGroup.getAllWhiteCheckedItems();
        if (list.size() == 0) {
            this.setErrorMessage(DataTransferMessages.FileImport_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }
}

