/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExportOperation;

public class WizardFileSystemResourceExportPage1
extends WizardExportResourcesPage
implements Listener {
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardFileSystemResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardFileSystemResourceExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardFileSystemResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String SELECT_DESTINATION_MESSAGE = DataTransferMessages.FileExport_selectDestinationMessage;
    private static final String SELECT_DESTINATION_TITLE = DataTransferMessages.FileExport_selectDestinationTitle;

    protected WizardFileSystemResourceExportPage1(String string, IStructuredSelection iStructuredSelection) {
        super(string, iStructuredSelection);
    }

    public WizardFileSystemResourceExportPage1(IStructuredSelection iStructuredSelection) {
        this("fileSystemExportPage1", iStructuredSelection);
        this.setTitle(DataTransferMessages.DataTransfer_fileSystemTitle);
        this.setDescription(DataTransferMessages.FileExport_exportLocalFileSystem);
    }

    protected void addDestinationItem(String string) {
        this.destinationNameField.add(string);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.giveFocusToDestination();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.file_system_export_wizard_page");
    }

    protected void createDestinationGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(this.getDestinationLabel());
        label.setFont(font);
        this.destinationNameField = new Combo(composite2, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)gridData);
        this.destinationNameField.setFont(font);
        this.destinationBrowseButton = new Button(composite2, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(composite, 0);
    }

    protected void createOptionsGroupButtons(Group group) {
        Font font = group.getFont();
        this.createOverwriteExisting(group, font);
        this.createDirectoryStructureOptions((Composite)group, font);
    }

    protected void createDirectoryStructureOptions(Composite composite, Font font) {
        this.createDirectoryStructureButton = new Button(composite, 16400);
        this.createDirectoryStructureButton.setText(DataTransferMessages.FileExport_createDirectoryStructure);
        this.createDirectoryStructureButton.setSelection(false);
        this.createDirectoryStructureButton.setFont(font);
        this.createSelectionOnlyButton = new Button(composite, 16400);
        this.createSelectionOnlyButton.setText(DataTransferMessages.FileExport_createSelectedDirectories);
        this.createSelectionOnlyButton.setSelection(true);
        this.createSelectionOnlyButton.setFont(font);
    }

    protected void createOverwriteExisting(Group group, Font font) {
        this.overwriteExistingFilesCheckbox = new Button((Composite)group, 16416);
        this.overwriteExistingFilesCheckbox.setText(DataTransferMessages.ExportFile_overwriteExisting);
        this.overwriteExistingFilesCheckbox.setFont(font);
    }

    protected boolean ensureDirectoryExists(File file) {
        if (!file.exists()) {
            if (!this.queryYesNoQuestion(DataTransferMessages.DataTransfer_createTargetDirectory)) {
                return false;
            }
            if (!file.mkdirs()) {
                this.displayErrorDialog(DataTransferMessages.DataTransfer_directoryCreationError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File file) {
        if (file.exists() && !file.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.FileExport_directoryExists);
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(file);
    }

    protected boolean executeExportOperation(FileSystemExportOperation fileSystemExportOperation) {
        fileSystemExportOperation.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        fileSystemExportOperation.setOverwriteFiles(this.overwriteExistingFilesCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)fileSystemExportOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.displayErrorDialog(invocationTargetException.getTargetException());
            return false;
        }
        IStatus iStatus = fileSystemExportOperation.getStatus();
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_exportProblems, null, (IStatus)iStatus);
            return false;
        }
        return true;
    }

    public boolean finish() {
        List list = this.getWhiteCheckedResources();
        if (!this.ensureTargetIsValid(new File(this.getDestinationValue()))) {
            return false;
        }
        this.saveDirtyEditors();
        this.saveWidgetValues();
        return this.executeExportOperation(new FileSystemExportOperation(null, list, this.getDestinationValue(), this));
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.FileExport_toDirectory;
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getContainer().getShell(), 8192);
        directoryDialog.setMessage(SELECT_DESTINATION_MESSAGE);
        directoryDialog.setText(SELECT_DESTINATION_TITLE);
        directoryDialog.setFilterPath(this.getDestinationValue());
        String string = directoryDialog.open();
        if (string != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(string);
        }
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES_ID);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            stringArray = this.addToHistory(stringArray, this.getDestinationValue());
            iDialogSettings.put(STORE_DESTINATION_NAMES_ID, stringArray);
            iDialogSettings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            iDialogSettings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES_ID);
            if (stringArray == null) {
                return;
            }
            this.setDestinationValue(stringArray[0]);
            boolean bl = false;
            while (bl < stringArray.length) {
                this.addDestinationItem(stringArray[bl]);
                bl += 1;
            }
            this.overwriteExistingFilesCheckbox.setSelection(iDialogSettings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            bl = iDialogSettings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(bl);
            this.createSelectionOnlyButton.setSelection(!bl);
        }
    }

    protected void setDestinationValue(String string) {
        this.destinationNameField.setText(string);
    }

    protected boolean validateDestinationGroup() {
        String string = this.getDestinationValue();
        if (string.length() == 0) {
            this.setMessage(this.destinationEmptyMessage());
            return false;
        }
        String string2 = this.getConflictingContainerNameFor(string);
        if (string2 == null) {
            String string3 = this.getOverlappingProjectName(string);
            if (string3 == null) {
                this.setMessage(null);
            } else {
                this.setMessage(NLS.bind((String)DataTransferMessages.FileExport_damageWarning, (Object)string3), 2);
            }
        } else {
            this.setErrorMessage(NLS.bind((String)DataTransferMessages.FileExport_conflictingContainer, (Object)string2));
            this.giveFocusToDestination();
            return false;
        }
        return true;
    }

    protected boolean validateSourceGroup() {
        boolean bl = true;
        List list = this.getWhiteCheckedResources();
        if (list.size() == 0) {
            this.setErrorMessage(DataTransferMessages.FileExport_noneSelected);
            bl = false;
        } else {
            this.setErrorMessage(null);
        }
        return super.validateSourceGroup() && bl;
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.FileExport_destinationEmpty;
    }

    protected String getConflictingContainerNameFor(String string) {
        String string2;
        Path path = new Path(string);
        IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (path.equals((Object)iPath)) {
            return iPath.lastSegment();
        }
        if (path.matchingFirstSegments(iPath) == iPath.segmentCount() && !Character.isLetterOrDigit((string2 = path.removeFirstSegments(iPath.segmentCount()).segment(0)).charAt(0))) {
            return string2;
        }
        return null;
    }

    private String getOverlappingProjectName(String string) {
        Path path;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] iContainerArray = iWorkspaceRoot.findContainersForLocation((IPath)(path = new Path(string)));
        if (iContainerArray.length > 0) {
            return iContainerArray[0].getProject().getName();
        }
        return null;
    }
}

