/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardFileSystemResourceImportPage1
extends WizardResourceImportPage
implements Listener {
    protected Combo sourceNameField;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createContainerStructureButton;
    protected Button createOnlySelectedButton;
    protected Button sourceBrowseButton;
    protected Button selectTypesButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private boolean entryChanged = false;
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardFileSystemResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = "WizardFileSystemResourceImportPage1.STORE_CREATE_CONTAINER_STRUCTURE_ID";
    private static final String SELECT_TYPES_TITLE = DataTransferMessages.DataTransfer_selectTypes;
    private static final String SELECT_ALL_TITLE = DataTransferMessages.DataTransfer_selectAll;
    private static final String DESELECT_ALL_TITLE = DataTransferMessages.DataTransfer_deselectAll;
    private static final String SELECT_SOURCE_TITLE = DataTransferMessages.FileImport_selectSourceTitle;
    private static final String SELECT_SOURCE_MESSAGE = DataTransferMessages.FileImport_selectSource;
    protected static final String SOURCE_EMPTY_MESSAGE = DataTransferMessages.FileImport_sourceEmpty;

    protected WizardFileSystemResourceImportPage1(String string, IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super(string, iStructuredSelection);
    }

    public WizardFileSystemResourceImportPage1(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this("fileSystemImportPage1", iWorkbench, iStructuredSelection);
        this.setTitle(DataTransferMessages.DataTransfer_fileSystemTitle);
        this.setDescription(DataTransferMessages.FileImport_importFileSystem);
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.setData((Object)new Integer(n));
        button.setText(string);
        if (bl) {
            Shell shell = composite.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        GridData gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.selectTypesButton = this.createButton(composite2, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardFileSystemResourceImportPage1.this.handleTypesEditButtonPressed();
            }
        };
        this.selectTypesButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.setButtonLayoutData(this.selectTypesButton);
        this.selectAllButton = this.createButton(composite2, 18, SELECT_ALL_TITLE, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(true);
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.setButtonLayoutData(this.selectAllButton);
        this.deselectAllButton = this.createButton(composite2, 19, DESELECT_ALL_TITLE, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(false);
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.setButtonLayoutData(this.deselectAllButton);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.validateSourceGroup();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.file_system_import_wizard_page");
    }

    protected void createOptionsGroupButtons(Group group) {
        this.overwriteExistingResourcesCheckbox = new Button((Composite)group, 32);
        this.overwriteExistingResourcesCheckbox.setFont(group.getFont());
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.FileImport_overwriteExisting);
        this.createContainerStructureButton = new Button((Composite)group, 16);
        this.createContainerStructureButton.setFont(group.getFont());
        this.createContainerStructureButton.setText(DataTransferMessages.FileImport_createComplete);
        this.createContainerStructureButton.setSelection(false);
        this.createOnlySelectedButton = new Button((Composite)group, 16);
        this.createOnlySelectedButton.setFont(group.getFont());
        this.createOnlySelectedButton.setText(DataTransferMessages.FileImport_createSelectedFolders);
        this.createOnlySelectedButton.setSelection(true);
    }

    protected void createRootDirectoryGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(this.getSourceLabel());
        label.setFont(composite.getFont());
        this.sourceNameField = new Combo(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)gridData);
        this.sourceNameField.setFont(composite.getFont());
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardFileSystemResourceImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                WizardFileSystemResourceImportPage1.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (WizardFileSystemResourceImportPage1.this.entryChanged) {
                    WizardFileSystemResourceImportPage1.this.entryChanged = false;
                    WizardFileSystemResourceImportPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(composite2, 8);
        this.sourceBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(composite.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected MinimizedFileSystemElement createRootElement(Object object, IImportStructureProvider iImportStructureProvider) {
        boolean bl = iImportStructureProvider.isFolder(object);
        String string = iImportStructureProvider.getLabel(object);
        MinimizedFileSystemElement minimizedFileSystemElement = new MinimizedFileSystemElement("", null, true);
        minimizedFileSystemElement.setPopulated();
        MinimizedFileSystemElement minimizedFileSystemElement2 = new MinimizedFileSystemElement(string, minimizedFileSystemElement, bl);
        minimizedFileSystemElement2.setFileSystemObject(object);
        minimizedFileSystemElement2.getFiles(iImportStructureProvider);
        return minimizedFileSystemElement;
    }

    protected void createSourceGroup(Composite composite) {
        this.createRootDirectoryGroup(composite);
        this.createFileSelectionGroup(composite);
        this.createButtonsGroup(composite);
    }

    protected void enableButtonGroup(boolean bl) {
        this.selectTypesButton.setEnabled(bl);
        this.selectAllButton.setEnabled(bl);
        this.deselectAllButton.setEnabled(bl);
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.setErrorMessage(DataTransferMessages.FileImport_invalidSource);
        return false;
    }

    protected boolean executeImportOperation(ImportOperation importOperation) {
        this.initializeOperation(importOperation);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)importOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.displayErrorDialog(invocationTargetException.getTargetException());
            return false;
        }
        IStatus iStatus = importOperation.getStatus();
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)iStatus);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator iterator = this.getSelectedResources().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            arrayList.add(((FileSystemElement)iterator.next()).getFileSystemObject());
        }
        if (arrayList.size() > 0) {
            return this.importResources(arrayList);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_information, (String)DataTransferMessages.FileImport_noneSelected);
        return false;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    return minimizedFileSystemElement.getFiles(FileSystemStructureProvider.INSTANCE).getChildren((Object)minimizedFileSystemElement);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File file = this.getSourceDirectory();
        if (file == null) {
            return null;
        }
        return this.selectFiles(file, FileSystemStructureProvider.INSTANCE);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    return minimizedFileSystemElement.getFolders(FileSystemStructureProvider.INSTANCE).getChildren((Object)minimizedFileSystemElement);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    if (minimizedFileSystemElement.isPopulated()) {
                        return this.getChildren((Object)minimizedFileSystemElement).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String string) {
        File file = new File(this.getSourceDirectoryName(string));
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        return file;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String string) {
        Path path = new Path(string.trim());
        path = path.getDevice() != null && path.segmentCount() == 0 ? path.addTrailingSeparator() : path.removeTrailingSeparator();
        return path.toOSString();
    }

    protected String getSourceLabel() {
        return DataTransferMessages.FileImport_fromDirectory;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        String string = this.sourceNameField.getText();
        DirectoryDialog directoryDialog = new DirectoryDialog(this.sourceNameField.getShell(), 8192);
        directoryDialog.setText(SELECT_SOURCE_TITLE);
        directoryDialog.setMessage(SELECT_SOURCE_MESSAGE);
        directoryDialog.setFilterPath(this.getSourceDirectoryName(string));
        String string2 = directoryDialog.open();
        if (string2 != null) {
            if (this.getSourceDirectory(string2) == null || string2.equals(string)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(string2);
            this.selectionGroup.setFocus();
        }
    }

    protected void handleTypesEditButtonPressed() {
        super.handleTypesEditButtonPressed();
    }

    protected boolean importResources(List list) {
        ImportOperation importOperation = new ImportOperation(this.getContainerFullPath(), this.getSourceDirectory(), FileSystemStructureProvider.INSTANCE, this, list);
        importOperation.setContext(this.getShell());
        return this.executeImportOperation(importOperation);
    }

    protected void initializeOperation(ImportOperation importOperation) {
        importOperation.setCreateContainerStructure(this.createContainerStructureButton.getSelection());
        importOperation.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected boolean isExportableExtension(String string) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator iterator = this.selectedTypes.iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement minimizedFileSystemElement = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)minimizedFileSystemElement);
    }

    protected void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_SOURCE_NAMES_ID);
            if (stringArray == null) {
                return;
            }
            boolean bl = false;
            while (bl < stringArray.length) {
                this.sourceNameField.add(stringArray[bl]);
                bl += 1;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(iDialogSettings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
            bl = iDialogSettings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID);
            this.createContainerStructureButton.setSelection(bl);
            this.createOnlySelectedButton.setSelection(!bl);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_SOURCE_NAMES_ID);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            stringArray = this.addToHistory(stringArray, this.getSourceDirectoryName());
            iDialogSettings.put(STORE_SOURCE_NAMES_ID, stringArray);
            iDialogSettings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            iDialogSettings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.createContainerStructureButton.getSelection());
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object object, final IImportStructureProvider iImportStructureProvider) {
        final MinimizedFileSystemElement[] minimizedFileSystemElementArray = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                minimizedFileSystemElementArray[0] = WizardFileSystemResourceImportPage1.this.createRootElement(object, iImportStructureProvider);
            }
        });
        return minimizedFileSystemElementArray[0];
    }

    protected void setAllSelections(boolean bl) {
        super.setAllSelections(bl);
    }

    protected void setSourceName(String string) {
        if (string.length() > 0) {
            String[] stringArray = this.sourceNameField.getItems();
            int n = -1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            if (n < 0) {
                n2 = stringArray.length;
                String[] stringArray2 = new String[n2 + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                stringArray2[n2] = string;
                this.sourceNameField.setItems(stringArray2);
                n = n2;
            }
            this.sourceNameField.select(n);
            this.resetSelection();
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorJobsDialog progressMonitorJobsDialog = new ProgressMonitorJobsDialog(this.getContainer().getShell());
        final Hashtable hashtable = new Hashtable();
        final IElementFilter iElementFilter = new IElementFilter(){

            public void filterElements(Collection collection, IProgressMonitor iProgressMonitor) throws InterruptedException {
                if (collection == null) {
                    throw new InterruptedException();
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(iterator.next());
                }
            }

            public void filterElements(Object[] objectArray, IProgressMonitor iProgressMonitor) throws InterruptedException {
                if (objectArray == null) {
                    throw new InterruptedException();
                }
                int n = 0;
                while (n < objectArray.length) {
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(objectArray[n]);
                    ++n;
                }
            }

            private void checkFile(Object object) {
                MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                if (WizardFileSystemResourceImportPage1.this.isExportableExtension(minimizedFileSystemElement.getFileNameExtension())) {
                    List<MinimizedFileSystemElement> list = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement fileSystemElement = minimizedFileSystemElement.getParent();
                    if (hashtable.containsKey(fileSystemElement)) {
                        list = (List)hashtable.get(fileSystemElement);
                    }
                    list.add(minimizedFileSystemElement);
                    hashtable.put(fileSystemElement, list);
                }
            }
        };
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                iProgressMonitor.beginTask(DataTransferMessages.ImportPage_filterSelections, -1);
                WizardFileSystemResourceImportPage1.this.getSelectedResources(iElementFilter, iProgressMonitor);
            }
        };
        try {
            progressMonitorJobsDialog.run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        if (hashtable != null) {
            this.updateSelections(hashtable);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.resetSelection();
        if (bl) {
            this.sourceNameField.setFocus();
        }
    }

    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        this.enableButtonGroup(this.ensureSourceIsValid());
    }

    protected boolean validateSourceGroup() {
        File file = this.getSourceDirectory();
        if (file == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(file.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        List list = this.selectionGroup.getAllWhiteCheckedItems();
        if (list.size() == 0) {
            this.setMessage(null);
            this.setErrorMessage(DataTransferMessages.FileImport_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }

    protected boolean sourceConflictsWithDestination(IPath iPath) {
        IContainer iContainer = this.getSpecifiedContainer();
        if (iContainer == null) {
            return false;
        }
        IPath iPath2 = this.getSpecifiedContainer().getLocation();
        if (iPath2 != null) {
            return iPath2.isPrefixOf(iPath);
        }
        return false;
    }
}

