/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;

public class ZipFileExporter
implements IFileExporter {
    private ZipOutputStream outputStream;
    private boolean useCompression = true;

    public ZipFileExporter(String string, boolean bl) throws IOException {
        this.outputStream = new ZipOutputStream(new FileOutputStream(string));
        this.useCompression = bl;
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    private void write(ZipEntry zipEntry, IFile iFile) throws IOException, CoreException {
        int n;
        InputStream inputStream;
        byte[] byArray = new byte[4096];
        if (!this.useCompression) {
            zipEntry.setMethod(0);
            inputStream = iFile.getContents(false);
            n = 0;
            CRC32 cRC32 = new CRC32();
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    cRC32.update(byArray, 0, n2);
                    n += n2;
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            zipEntry.setSize(n);
            zipEntry.setCrc(cRC32.getValue());
        }
        this.outputStream.putNextEntry(zipEntry);
        inputStream = iFile.getContents(false);
        try {
            while ((n = inputStream.read(byArray)) > 0) {
                this.outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.outputStream.closeEntry();
    }

    public void write(IFile iFile, String string) throws IOException, CoreException {
        ZipEntry zipEntry = new ZipEntry(string);
        this.write(zipEntry, iFile);
    }
}

