/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class ZipLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();
    private int stripLevel;

    public ZipLeveledStructureProvider(ZipFile zipFile) {
        this.zipFile = zipFile;
        this.stripLevel = 0;
    }

    protected ZipEntry createContainer(IPath iPath) {
        ZipEntry zipEntry = (ZipEntry)this.directoryEntryCache.get(iPath);
        if (zipEntry != null) {
            return zipEntry;
        }
        ZipEntry zipEntry2 = iPath.segmentCount() == 1 ? this.root : this.createContainer(iPath.removeLastSegments(1));
        ZipEntry zipEntry3 = new ZipEntry(iPath.toString());
        this.directoryEntryCache.put(iPath, zipEntry3);
        ArrayList arrayList = new ArrayList();
        this.children.put(zipEntry3, arrayList);
        List list = (List)this.children.get(zipEntry2);
        list.add(zipEntry3);
        return zipEntry3;
    }

    protected void createFile(ZipEntry zipEntry) {
        Path path = new Path(zipEntry.getName());
        ZipEntry zipEntry2 = path.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(path.removeLastSegments(1));
        List list = (List)this.children.get(zipEntry2);
        list.add(zipEntry);
    }

    public List getChildren(Object object) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(object);
    }

    public InputStream getContents(Object object) {
        try {
            return this.zipFile.getInputStream((ZipEntry)object);
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.log(iOException.getLocalizedMessage(), iOException);
            return null;
        }
    }

    private String stripPath(String string) {
        String string2 = new String(string);
        int n = 0;
        while (n < this.stripLevel) {
            int n2 = string.indexOf(47);
            if (n2 == 0) {
                string = string.substring(1);
                n2 = string.indexOf(47);
            }
            if (n2 == -1) {
                return string2;
            }
            string = string.substring(n2);
            ++n;
        }
        return string;
    }

    public String getFullPath(Object object) {
        return this.stripPath(((ZipEntry)object).getName());
    }

    public String getLabel(Object object) {
        if (object.equals(this.root)) {
            return ((ZipEntry)object).getName();
        }
        return this.stripPath(new Path(((ZipEntry)object).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public boolean closeArchive() {
        try {
            this.getZipFile().close();
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.log(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getZipFile().getName(), iOException);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            IPath iPath = new Path(zipEntry.getName()).addTrailingSeparator();
            if (zipEntry.isDirectory()) {
                this.createContainer(iPath);
                continue;
            }
            int n = iPath.segmentCount();
            if (n > 1) {
                this.createContainer(iPath.uptoSegment(n - 1));
            }
            this.createFile(zipEntry);
        }
    }

    public boolean isFolder(Object object) {
        return ((ZipEntry)object).isDirectory();
    }

    public void setStrip(int n) {
        this.stripLevel = n;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

