/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class WorkbenchContentProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener {
    private Viewer viewer;

    public void dispose() {
        if (this.viewer != null) {
            IWorkspace iWorkspace = null;
            Object object = this.viewer.getInput();
            if (object instanceof IWorkspace) {
                iWorkspace = (IWorkspace)object;
            } else if (object instanceof IContainer) {
                iWorkspace = ((IContainer)object).getWorkspace();
            }
            if (iWorkspace != null) {
                iWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.viewer = viewer;
        IWorkspace iWorkspace = null;
        IWorkspace iWorkspace2 = null;
        if (object instanceof IWorkspace) {
            iWorkspace = (IWorkspace)object;
        } else if (object instanceof IContainer) {
            iWorkspace = ((IContainer)object).getWorkspace();
        }
        if (object2 instanceof IWorkspace) {
            iWorkspace2 = (IWorkspace)object2;
        } else if (object2 instanceof IContainer) {
            iWorkspace2 = ((IContainer)object2).getWorkspace();
        }
        if (iWorkspace != iWorkspace2) {
            if (iWorkspace != null) {
                iWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (iWorkspace2 != null) {
                iWorkspace2.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    public final void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        this.processDelta(iResourceChangeEvent.getDelta());
    }

    protected void processDelta(IResourceDelta iResourceDelta) {
        Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        this.processDelta(iResourceDelta, arrayList);
        if (arrayList.isEmpty()) {
            return;
        }
        if (control.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(arrayList);
        } else {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control control = WorkbenchContentProvider.this.viewer.getControl();
                    if (control == null || control.isDisposed()) {
                        return;
                    }
                    WorkbenchContentProvider.this.runUpdates(arrayList);
                }
            });
        }
    }

    private void runUpdates(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Runnable)iterator.next()).run();
        }
    }

    private void processDelta(IResourceDelta iResourceDelta, Collection collection) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        IResource iResource = iResourceDelta.getResource();
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
        int n2 = 0;
        while (n2 < iResourceDeltaArray.length) {
            if ((iResourceDeltaArray[n2].getFlags() & 0x8000) != 0) {
                collection.add(this.getRefreshRunnable(iResource));
                return;
            }
            ++n2;
        }
        n2 = iResourceDelta.getFlags();
        if ((n2 & 0x4000) != 0) {
            if (iResource.isAccessible()) {
                collection.add(this.getUpdateRunnable(iResource));
            } else {
                collection.add(this.getRefreshRunnable(iResource));
                return;
            }
        }
        if ((n2 & 0x98000) != 0) {
            collection.add(this.getUpdateRunnable(iResource));
        }
        if ((n2 & 0x40000) != 0) {
            collection.add(this.getRefreshRunnable(iResource));
            return;
        }
        int n3 = 0;
        while (n3 < iResourceDeltaArray.length) {
            this.processDelta(iResourceDeltaArray[n3], collection);
            ++n3;
        }
        IResourceDelta[] iResourceDeltaArray2 = iResourceDelta.getAffectedChildren(1);
        IResourceDelta[] iResourceDeltaArray3 = iResourceDelta.getAffectedChildren(2);
        if (iResourceDeltaArray2.length == 0 && iResourceDeltaArray3.length == 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        if (iResourceDeltaArray2.length > 0) {
            objectArray2 = new Object[iResourceDeltaArray2.length];
            n = 0;
            while (n < iResourceDeltaArray2.length) {
                objectArray2[n] = iResourceDeltaArray2[n].getResource();
                if ((iResourceDeltaArray2[n].getFlags() & 0x1000) != 0) {
                    ++n4;
                }
                ++n;
            }
        } else {
            objectArray2 = new Object[]{};
        }
        if (iResourceDeltaArray3.length > 0) {
            objectArray = new Object[iResourceDeltaArray3.length];
            n = 0;
            while (n < iResourceDeltaArray3.length) {
                objectArray[n] = iResourceDeltaArray3[n].getResource();
                if ((iResourceDeltaArray3[n].getFlags() & 0x2000) != 0) {
                    ++n5;
                }
                ++n;
            }
        } else {
            objectArray = new Object[]{};
        }
        n = n4 > 0 && n5 > 0 ? 1 : 0;
        Runnable runnable = new Runnable(n != 0, objectArray2, iResource, objectArray){
            private final /* synthetic */ boolean val$hasRename;
            private final /* synthetic */ Object[] val$addedObjects;
            private final /* synthetic */ IResource val$resource;
            private final /* synthetic */ Object[] val$removedObjects;
            {
                this.val$hasRename = bl;
                this.val$addedObjects = objectArray;
                this.val$resource = iResource;
                this.val$removedObjects = objectArray2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (WorkbenchContentProvider.this.viewer instanceof AbstractTreeViewer) {
                    AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)WorkbenchContentProvider.this.viewer;
                    if (this.val$hasRename) {
                        abstractTreeViewer.getControl().setRedraw(false);
                    }
                    try {
                        if (this.val$addedObjects.length > 0) {
                            abstractTreeViewer.add((Object)this.val$resource, this.val$addedObjects);
                        }
                        if (this.val$removedObjects.length <= 0) return;
                        abstractTreeViewer.remove(this.val$removedObjects);
                        return;
                    }
                    finally {
                        if (this.val$hasRename) {
                            abstractTreeViewer.getControl().setRedraw(true);
                        }
                    }
                } else {
                    ((StructuredViewer)WorkbenchContentProvider.this.viewer).refresh((Object)this.val$resource);
                }
            }
        };
        collection.add(runnable);
    }

    private Runnable getRefreshRunnable(final IResource iResource) {
        return new Runnable(){

            public void run() {
                ((StructuredViewer)WorkbenchContentProvider.this.viewer).refresh((Object)iResource);
            }
        };
    }

    private Runnable getUpdateRunnable(final IResource iResource) {
        return new Runnable(){

            public void run() {
                ((StructuredViewer)WorkbenchContentProvider.this.viewer).update((Object)iResource, null);
            }
        };
    }
}

