/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.FileEditorInputFactory;

public class FileEditorInput
extends PlatformObject
implements IFileEditorInput,
IPathEditorInput,
IURIEditorInput,
IPersistableElement {
    private IFile file;
    static /* synthetic */ Class class$0;

    public static boolean isLocalFile(IFile iFile) {
        URI uRI;
        block5: {
            IPath iPath = iFile.getLocation();
            if (iPath != null) {
                return true;
            }
            try {
                uRI = iFile.getLocationURI();
                if (uRI != null) break block5;
                return false;
            }
            catch (CoreException coreException) {
                IDEWorkbenchPlugin.log("Failed to obtain file store for resource", coreException);
                return false;
            }
        }
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        File file = iFileStore.toLocalFile(0, null);
        if (file == null) {
            file = iFileStore.toLocalFile(4096, null);
        }
        return file != null;
    }

    public FileEditorInput(IFile iFile) {
        if (iFile == null) {
            throw new IllegalArgumentException();
        }
        this.file = iFile;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IFileEditorInput)) {
            return false;
        }
        IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
        return this.file.equals((Object)iFileEditorInput.getFile());
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getFactoryId() {
        return FileEditorInputFactory.getFactoryId();
    }

    public IFile getFile() {
        return this.file;
    }

    public ImageDescriptor getImageDescriptor() {
        IContentType iContentType = IDE.getContentType(this.file);
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName(), iContentType);
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public IStorage getStorage() {
        return this.file;
    }

    public String getToolTipText() {
        return this.file.getFullPath().makeRelative().toString();
    }

    public void saveState(IMemento iMemento) {
        FileEditorInputFactory.saveState(iMemento, this);
    }

    public URI getURI() {
        return this.file.getLocationURI();
    }

    public IPath getPath() {
        IPath iPath = this.file.getLocation();
        if (iPath != null) {
            return iPath;
        }
        try {
            URI uRI = this.file.getLocationURI();
            if (uRI == null) {
                throw new IllegalArgumentException();
            }
            IFileStore iFileStore = EFS.getStore((URI)uRI);
            File file = iFileStore.toLocalFile(0, null);
            if (file == null) {
                file = iFileStore.toLocalFile(4096, null);
            }
            if (file == null) {
                throw new IllegalArgumentException();
            }
            return Path.fromOSString((String)file.getAbsolutePath());
        }
        catch (CoreException coreException) {
            IDEWorkbenchPlugin.log("Failed to obtain file store for resource", coreException);
            throw new RuntimeException(coreException);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getFile().getFullPath() + ")";
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object object) {
                    return new Object[0];
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return FileEditorInput.this.getImageDescriptor();
                }

                public String getLabel(Object object) {
                    return FileEditorInput.this.getName();
                }

                public Object getParent(Object object) {
                    return FileEditorInput.this.getFile().getParent();
                }
            };
        }
        return super.getAdapter(clazz);
    }
}

