/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class MarkerTransfer
extends ByteArrayTransfer {
    private static final MarkerTransfer instance = new MarkerTransfer();
    private static final String TYPE_NAME = "marker-transfer-format" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = MarkerTransfer.registerType((String)TYPE_NAME);
    private IWorkspace workspace;

    private MarkerTransfer() {
    }

    private IMarker findMarker(String string, long l) {
        Path path = new Path(string);
        IResource iResource = this.workspace.getRoot().findMember((IPath)path);
        if (iResource != null) {
            return iResource.getMarker(l);
        }
        return null;
    }

    public static MarkerTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        Object[] objectArray = (Object[])object;
        this.lazyInit(objectArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            dataOutputStream.writeInt(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                this.writeMarker((IMarker)objectArray[n], dataOutputStream);
                ++n;
            }
            dataOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {}
        if (byArray != null) {
            super.javaToNative((Object)byArray, transferData);
        }
    }

    private void lazyInit(Object[] objectArray) {
        if (this.workspace == null && objectArray != null && objectArray.length > 0) {
            this.workspace = ((IMarker)objectArray[0]).getResource().getWorkspace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object nativeToJava(TransferData transferData) {
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n = dataInputStream.readInt();
            IMarker[] iMarkerArray = new IMarker[n];
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return iMarkerArray;
                }
                IMarker iMarker = this.readMarker(dataInputStream);
                if (iMarker == null) {
                    return null;
                }
                iMarkerArray[n2] = iMarker;
                ++n2;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IMarker readMarker(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        long l = dataInputStream.readLong();
        return this.findMarker(string, l);
    }

    private void writeMarker(IMarker iMarker, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(iMarker.getResource().getFullPath().toString());
        dataOutputStream.writeLong(iMarker.getId());
    }
}

