/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ResourceTransfer
extends ByteArrayTransfer {
    private static final ResourceTransfer instance = new ResourceTransfer();
    private static final String TYPE_NAME = "resource-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = ResourceTransfer.registerType((String)TYPE_NAME);
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();

    private ResourceTransfer() {
    }

    public static ResourceTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof IResource[])) {
            return;
        }
        IResource[] iResourceArray = (IResource[])object;
        int n = iResourceArray.length;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < iResourceArray.length) {
                this.writeResource(dataOutputStream, iResourceArray[n2]);
                ++n2;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            super.javaToNative((Object)byArray, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        if (byArray == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n = dataInputStream.readInt();
            IResource[] iResourceArray = new IResource[n];
            int n2 = 0;
            while (n2 < n) {
                iResourceArray[n2] = this.readResource(dataInputStream);
                ++n2;
            }
            return iResourceArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IResource readResource(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        switch (n) {
            case 2: {
                return this.workspace.getRoot().getFolder((IPath)new Path(string));
            }
            case 1: {
                return this.workspace.getRoot().getFile((IPath)new Path(string));
            }
            case 4: {
                return this.workspace.getRoot().getProject(string);
            }
        }
        throw new IllegalArgumentException("Unknown resource type in ResourceTransfer.readResource");
    }

    private void writeResource(DataOutputStream dataOutputStream, IResource iResource) throws IOException {
        dataOutputStream.writeInt(iResource.getType());
        dataOutputStream.writeUTF(iResource.getFullPath().toString());
    }
}

